/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.render.texture;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.glu.GLU;
import org.newdawn.render.texture.DeferredTexture;
import org.newdawn.render.texture.TGALoader;
import org.newdawn.render.texture.Texture;
import org.newdawn.state.loading.LoadingList;
import org.newdawn.util.ResourceLoader;

public class TextureLoader {
    private static final TextureLoader loader = new TextureLoader();
    private boolean deferredLoading;
    private HashMap nearest = new HashMap();
    private HashMap linear = new HashMap();
    private HashMap mipmap = new HashMap();
    private ArrayList nearestList = new ArrayList();
    private ArrayList linearList = new ArrayList();
    private ArrayList mipmapList = new ArrayList();
    private HashMap images = new HashMap();
    private int dstPixelFormat = 6408;

    public static TextureLoader get() {
        return loader;
    }

    public void set16BitMode() {
        this.dstPixelFormat = 32859;
    }

    private int createTextureID() {
        IntBuffer tmp = this.createIntBuffer(1);
        GL11.glGenTextures((IntBuffer)tmp);
        return tmp.get(0);
    }

    public void release() {
        Iterator n = this.nearest.values().iterator();
        while (n.hasNext()) {
            ((Texture)n.next()).release();
        }
        Iterator l = this.linear.values().iterator();
        while (l.hasNext()) {
            ((Texture)l.next()).release();
        }
        Iterator m = this.mipmap.values().iterator();
        while (m.hasNext()) {
            ((Texture)m.next()).release();
        }
    }

    public void refresh() throws IOException {
        this.nearest.clear();
        this.linear.clear();
        this.mipmap.clear();
        ArrayList nList = this.nearestList;
        this.nearestList = new ArrayList();
        ArrayList lList = this.linearList;
        this.linearList = new ArrayList();
        ArrayList mList = this.mipmapList;
        this.mipmapList = new ArrayList();
        Iterator n = nList.iterator();
        while (n.hasNext()) {
            Texture tex = (Texture)n.next();
            Texture temp = this.getTextureNearest(tex.getTextureRef());
            tex.setTextureID(temp.getTextureID());
        }
        Iterator l = lList.iterator();
        while (l.hasNext()) {
            Texture tex = (Texture)l.next();
            Texture temp = this.getTextureLinear(tex.getTextureRef());
            tex.setTextureID(temp.getTextureID());
        }
        Iterator m = mList.iterator();
        while (m.hasNext()) {
            Texture tex = (Texture)m.next();
            Texture temp = this.getTextureMipMap(tex.getTextureRef());
            tex.setTextureID(temp.getTextureID());
        }
        Texture.lastBind = null;
    }

    public void setDeferredLoading(boolean deferredLoading) {
        this.deferredLoading = deferredLoading;
    }

    public boolean getDeferredLoading() {
        return this.deferredLoading;
    }

    public Texture getTextureNearest(String resourceName) throws IOException {
        Texture tex = (Texture)this.nearest.get(resourceName);
        if (tex != null && (!(tex instanceof DeferredTexture) || this.deferredLoading)) {
            return tex;
        }
        if (this.deferredLoading) {
            DeferredTexture texture = new DeferredTexture(resourceName, 1);
            LoadingList.addLoadable(texture);
            this.nearest.put(resourceName, texture);
            return texture;
        }
        tex = this.getTexture(resourceName, 3553, 9728, 9728);
        this.nearest.put(resourceName, tex);
        this.nearestList.add(tex);
        return tex;
    }

    public Texture getTextureLinear(String resourceName) throws IOException {
        Texture tex = (Texture)this.linear.get(resourceName);
        if (tex != null && (!(tex instanceof DeferredTexture) || this.deferredLoading)) {
            return tex;
        }
        if (this.deferredLoading) {
            DeferredTexture texture = new DeferredTexture(resourceName, 2);
            LoadingList.addLoadable(texture);
            this.linear.put(resourceName, texture);
            return texture;
        }
        tex = this.getTexture(resourceName, 3553, 9729, 9729);
        this.linear.put(resourceName, tex);
        this.linearList.add(tex);
        return tex;
    }

    public Texture getTextureMipMap(String resourceName) throws IOException {
        Texture tex = (Texture)this.mipmap.get(resourceName);
        if (tex != null && (!(tex instanceof DeferredTexture) || this.deferredLoading)) {
            return tex;
        }
        if (this.deferredLoading) {
            DeferredTexture texture = new DeferredTexture(resourceName, 3);
            LoadingList.addLoadable(texture);
            this.mipmap.put(resourceName, texture);
            return texture;
        }
        tex = this.getTexture(resourceName, 3553, 9729, 9985);
        this.mipmap.put(resourceName, tex);
        this.mipmapList.add(tex);
        return tex;
    }

    public Texture getTexture(String resourceName, int target, int magFilter, int minFilter) throws IOException {
        int textureID = this.createTextureID();
        Texture texture = new Texture(resourceName, target, textureID);
        GL11.glBindTexture((int)target, (int)textureID);
        ByteBuffer textureBuffer = TGALoader.loadImage(new BufferedInputStream(ResourceLoader.getResourceAsStream((String)resourceName)));
        int width = TGALoader.getLastWidth();
        int height = TGALoader.getLastHeight();
        boolean hasAlpha = TGALoader.getLastDepth() == 32;
        texture.setTextureWidth(TGALoader.getLastTexWidth());
        texture.setTextureHeight(TGALoader.getLastTexHeight());
        int texWidth = texture.getTextureWidth();
        int texHeight = texture.getTextureHeight();
        int srcPixelFormat = hasAlpha ? 6408 : 6407;
        int componentCount = hasAlpha ? 4 : 3;
        texture.setWidth(width);
        texture.setHeight(height);
        GL11.glTexParameteri((int)target, (int)10241, (int)minFilter);
        GL11.glTexParameteri((int)target, (int)10240, (int)magFilter);
        if (minFilter == 9985) {
            GLU.gluBuild2DMipmaps((int)3553, (int)componentCount, (int)texWidth, (int)texHeight, (int)srcPixelFormat, (int)5121, (ByteBuffer)textureBuffer);
        } else {
            GL11.glTexImage2D((int)target, (int)0, (int)this.dstPixelFormat, (int)this.get2Fold(width), (int)this.get2Fold(height), (int)0, (int)srcPixelFormat, (int)5121, (ByteBuffer)textureBuffer);
        }
        return texture;
    }

    private int get2Fold(int fold) {
        int ret;
        for (ret = 2; ret < fold; ret *= 2) {
        }
        return ret;
    }

    protected IntBuffer createIntBuffer(int size) {
        ByteBuffer temp = ByteBuffer.allocateDirect(4 * size);
        temp.order(ByteOrder.nativeOrder());
        return temp.asIntBuffer();
    }
}

