/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.render.texture;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL11;

public class Texture {
    static Texture lastBind;
    private int target;
    private int textureID;
    private int height;
    private int width;
    private int texWidth;
    private int texHeight;
    private float widthRatio;
    private float heightRatio;
    private boolean alpha;
    private String ref;

    protected Texture() {
    }

    public Texture(String ref, int target, int textureID) {
        this.target = target;
        this.ref = ref;
        this.textureID = textureID;
        lastBind = this;
    }

    public String getTextureRef() {
        return this.ref;
    }

    public void setAlpha(boolean alpha) {
        this.alpha = alpha;
    }

    public static void bindNone() {
        lastBind = null;
        GL11.glDisable((int)3553);
    }

    public void bind() {
        if (lastBind != this) {
            lastBind = this;
            GL11.glEnable((int)3553);
            GL11.glBindTexture((int)this.target, (int)this.textureID);
        }
    }

    public void setHeight(int height) {
        this.height = height;
        this.setHeight();
    }

    public void setWidth(int width) {
        this.width = width;
        this.setWidth();
    }

    public int getImageHeight() {
        return this.height;
    }

    public int getImageWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.heightRatio;
    }

    public float getWidth() {
        return this.widthRatio;
    }

    public int getTextureHeight() {
        return this.texHeight;
    }

    public int getTextureWidth() {
        return this.texWidth;
    }

    public void setTextureHeight(int texHeight) {
        this.texHeight = texHeight;
        this.setHeight();
    }

    public void setTextureWidth(int texWidth) {
        this.texWidth = texWidth;
        this.setWidth();
    }

    private void setHeight() {
        if (this.texHeight != 0) {
            this.heightRatio = (float)this.height / (float)this.texHeight;
        }
    }

    private void setWidth() {
        if (this.texWidth != 0) {
            this.widthRatio = (float)this.width / (float)this.texWidth;
        }
    }

    public void release() {
        IntBuffer texBuf = this.createIntBuffer(1);
        texBuf.put(this.textureID);
        texBuf.flip();
        GL11.glDeleteTextures((IntBuffer)texBuf);
    }

    public int getTextureID() {
        return this.textureID;
    }

    public void setTextureID(int textureID) {
        this.textureID = textureID;
    }

    protected IntBuffer createIntBuffer(int size) {
        ByteBuffer temp = ByteBuffer.allocateDirect(4 * size);
        temp.order(ByteOrder.nativeOrder());
        return temp.asIntBuffer();
    }
}

