/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.render.texture;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.lwjgl.BufferUtils;

public class TGALoader {
    private static int texWidth;
    private static int texHeight;
    private static int width;
    private static int height;
    private static short pixelDepth;

    private TGALoader() {
    }

    private static short flipEndian(short signedShort) {
        int input = signedShort & 0xFFFF;
        return (short)(input << 8 | (input & 0xFF00) >>> 8);
    }

    public static int getLastDepth() {
        return pixelDepth;
    }

    public static int getLastWidth() {
        return width;
    }

    public static int getLastHeight() {
        return height;
    }

    public static int getLastTexWidth() {
        return texWidth;
    }

    public static int getLastTexHeight() {
        return texHeight;
    }

    public static ByteBuffer loadImage(InputStream fis) throws IOException {
        return TGALoader.loadImage(fis, true);
    }

    public static ByteBuffer loadImage(InputStream fis, boolean flipped) throws IOException {
        int i;
        byte red = 0;
        byte green = 0;
        byte blue = 0;
        byte alpha = 0;
        BufferedInputStream bis = new BufferedInputStream(fis, 100000);
        DataInputStream dis = new DataInputStream(bis);
        short idLength = (short)dis.read();
        short colorMapType = (short)dis.read();
        short imageType = (short)dis.read();
        short cMapStart = TGALoader.flipEndian(dis.readShort());
        short cMapLength = TGALoader.flipEndian(dis.readShort());
        short cMapDepth = (short)dis.read();
        short xOffset = TGALoader.flipEndian(dis.readShort());
        short yOffset = TGALoader.flipEndian(dis.readShort());
        width = TGALoader.flipEndian(dis.readShort());
        height = TGALoader.flipEndian(dis.readShort());
        pixelDepth = (short)dis.read();
        texWidth = TGALoader.get2Fold(width);
        texHeight = TGALoader.get2Fold(height);
        short imageDescriptor = (short)dis.read();
        if (idLength > 0) {
            bis.skip(idLength);
        }
        byte[] rawData = null;
        rawData = pixelDepth == 32 ? new byte[texWidth * texHeight * 4] : new byte[texWidth * texHeight * 3];
        if (pixelDepth == 24) {
            for (i = height - 1; i >= 0; --i) {
                for (int j = 0; j < width; ++j) {
                    blue = dis.readByte();
                    green = dis.readByte();
                    red = dis.readByte();
                    int ofs = (j + i * texWidth) * 3;
                    rawData[ofs] = red;
                    rawData[ofs + 1] = green;
                    rawData[ofs + 2] = blue;
                }
            }
        } else if (pixelDepth == 32) {
            if (flipped) {
                for (i = height - 1; i >= 0; --i) {
                    for (int j = 0; j < width; ++j) {
                        blue = dis.readByte();
                        green = dis.readByte();
                        red = dis.readByte();
                        alpha = dis.readByte();
                        int ofs = (j + i * texWidth) * 4;
                        rawData[ofs] = red;
                        rawData[ofs + 1] = green;
                        rawData[ofs + 2] = blue;
                        rawData[ofs + 3] = alpha;
                        if (alpha != 0) continue;
                        rawData[ofs + 2] = 0;
                        rawData[ofs + 1] = 0;
                        rawData[ofs] = 0;
                    }
                }
            } else {
                for (i = 0; i < height; ++i) {
                    for (int j = 0; j < width; ++j) {
                        blue = dis.readByte();
                        green = dis.readByte();
                        red = dis.readByte();
                        alpha = dis.readByte();
                        int ofs = (j + i * texWidth) * 4;
                        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
                            rawData[ofs] = red;
                            rawData[ofs + 1] = green;
                            rawData[ofs + 2] = blue;
                            rawData[ofs + 3] = alpha;
                        } else {
                            rawData[ofs + 2] = red;
                            rawData[ofs + 1] = green;
                            rawData[ofs] = blue;
                            rawData[ofs + 3] = alpha;
                        }
                        if (alpha != 0) continue;
                        rawData[ofs + 2] = 0;
                        rawData[ofs + 1] = 0;
                        rawData[ofs] = 0;
                    }
                }
            }
        }
        fis.close();
        ByteBuffer scratch = BufferUtils.createByteBuffer((int)rawData.length);
        scratch.put(rawData);
        scratch.flip();
        return scratch;
    }

    private static int get2Fold(int fold) {
        int ret;
        for (ret = 2; ret < fold; ret *= 2) {
        }
        return ret;
    }
}

