/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.render.texture;

import java.io.IOException;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.state.loading.Loadable;

public class DeferredTexture
extends Texture
implements Loadable {
    public static final int NEAREST = 1;
    public static final int LINEAR = 2;
    public static final int MIPMAP = 3;
    private String ref;
    private int type;
    private Texture target;

    public DeferredTexture(String ref, int type) {
        this.ref = ref;
        this.type = type;
    }

    public void load() throws IOException {
        TextureLoader.get().setDeferredLoading(false);
        switch (this.type) {
            case 1: {
                this.target = TextureLoader.get().getTextureNearest(this.ref);
                break;
            }
            case 2: {
                this.target = TextureLoader.get().getTextureLinear(this.ref);
                break;
            }
            case 3: {
                this.target = TextureLoader.get().getTextureMipMap(this.ref);
            }
        }
        TextureLoader.get().setDeferredLoading(true);
    }

    public String getMessage() {
        return this.ref;
    }

    private void checkTarget() {
        if (this.target == null) {
            throw new RuntimeException("Deferred Loading requires a loading state to have completed init()");
        }
    }

    public void bind() {
        this.checkTarget();
        this.target.bind();
    }

    public float getHeight() {
        this.checkTarget();
        return this.target.getHeight();
    }

    public int getImageHeight() {
        this.checkTarget();
        return this.target.getImageHeight();
    }

    public int getImageWidth() {
        this.checkTarget();
        return this.target.getImageWidth();
    }

    public int getTextureHeight() {
        this.checkTarget();
        return this.target.getTextureHeight();
    }

    public int getTextureID() {
        this.checkTarget();
        return this.target.getTextureID();
    }

    public String getTextureRef() {
        this.checkTarget();
        return this.target.getTextureRef();
    }

    public int getTextureWidth() {
        this.checkTarget();
        return this.target.getTextureWidth();
    }

    public float getWidth() {
        this.checkTarget();
        return this.target.getWidth();
    }

    public void release() {
        this.checkTarget();
        this.target.release();
    }

    public void setAlpha(boolean alpha) {
        this.checkTarget();
        this.target.setAlpha(alpha);
    }

    public void setHeight(int height) {
        this.checkTarget();
        this.target.setHeight(height);
    }

    public void setTextureHeight(int texHeight) {
        this.checkTarget();
        this.target.setTextureHeight(texHeight);
    }

    public void setTextureID(int textureID) {
        this.checkTarget();
        this.target.setTextureID(textureID);
    }

    public void setTextureWidth(int texWidth) {
        this.checkTarget();
        this.target.setTextureWidth(texWidth);
    }

    public void setWidth(int width) {
        this.checkTarget();
        this.target.setWidth(width);
    }
}

