/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.render.texture;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Cursor;
import org.newdawn.render.texture.TGALoader;
import org.newdawn.util.ResourceLoader;

public class CursorLoader {
    private static CursorLoader single = new CursorLoader();

    public static CursorLoader get() {
        return single;
    }

    private CursorLoader() {
    }

    public Cursor getCursor(String ref, int x, int y) throws IOException, LWJGLException {
        ByteBuffer buf = TGALoader.loadImage(ResourceLoader.getResourceAsStream((String)ref), false);
        try {
            return new Cursor(TGALoader.getLastWidth(), TGALoader.getLastHeight(), x, y, 1, buf.asIntBuffer(), null);
        }
        catch (Throwable e) {
            throw new LWJGLException(e);
        }
    }

    public Cursor getAnimatedCursor(String ref, int x, int y, int width, int height, int[] cursorDelays) throws IOException, LWJGLException {
        IntBuffer cursorDelaysBuffer = ByteBuffer.allocateDirect(cursorDelays.length * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
        for (int i = 0; i < cursorDelays.length; ++i) {
            cursorDelaysBuffer.put(cursorDelays[i]);
        }
        cursorDelaysBuffer.flip();
        ByteBuffer buf = TGALoader.loadImage(ResourceLoader.getResourceAsStream((String)ref), false);
        return new Cursor(width, height, x, y, cursorDelays.length, buf.asIntBuffer(), cursorDelaysBuffer);
    }
}

