/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.render.sprite;

import java.io.IOException;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.render.util.Color;

public class SpriteSheet {
    protected Texture texture;
    private int width;
    private int height;
    private float tileWidth;
    private float tileHeight;
    private float tw;
    private float th;

    public SpriteSheet(String ref, float tw, float th) {
        try {
            this.tw = tw;
            this.th = th;
            boolean before = TextureLoader.get().getDeferredLoading();
            TextureLoader.get().setDeferredLoading(false);
            this.texture = TextureLoader.get().getTextureLinear(ref);
            TextureLoader.get().setDeferredLoading(before);
            this.width = this.texture.getImageWidth();
            this.height = this.texture.getImageHeight();
            this.tileWidth = tw / (float)this.width;
            this.tileHeight = th / (float)this.height;
        }
        catch (IOException e) {
            System.err.println("Unable to load sprite sheet: " + ref);
            System.exit(0);
        }
    }

    public void draw(int x, int y, int sx, int sy, float scale) {
        this.draw(x, y, sx, sy, (int)(this.tw * scale), (int)(this.th * scale));
    }

    public void draw(int x, int y, int sx, int sy) {
        this.draw(x, y, sx, sy, (int)this.tw, (int)this.th);
    }

    public void draw(int x, int y, int sx, int sy, int tw, int th) {
        this.texture.bind();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)((float)sx * this.tileWidth), (float)((float)sy * this.tileHeight));
        GL11.glVertex2f((float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)((float)sx * this.tileWidth), (float)((float)sy * this.tileHeight + this.tileHeight));
        GL11.glVertex2f((float)0.0f, (float)th);
        GL11.glTexCoord2f((float)((float)(sx + 1) * this.tileWidth), (float)((float)sy * this.tileHeight + this.tileHeight));
        GL11.glVertex2f((float)tw, (float)th);
        GL11.glTexCoord2f((float)((float)(sx + 1) * this.tileWidth), (float)((float)sy * this.tileHeight));
        GL11.glVertex2f((float)tw, (float)0.0f);
        GL11.glEnd();
        GL11.glTranslatef((float)(-x), (float)(-y), (float)0.0f);
    }

    public void drawQuad(int x, int y, int sx, int sy, float scale) {
        this.drawQuad(x, y, sx, sy, (int)(this.tw * scale), (int)(this.th * scale));
    }

    public void drawQuad(int x, int y, int sx, int sy, int tw, int th) {
        GL11.glTexCoord2f((float)((float)sx * this.tileWidth), (float)((float)sy * this.tileHeight));
        GL11.glVertex2f((float)x, (float)y);
        GL11.glTexCoord2f((float)((float)sx * this.tileWidth), (float)((float)sy * this.tileHeight + this.tileHeight));
        GL11.glVertex2f((float)x, (float)(y + th));
        GL11.glTexCoord2f((float)((float)(sx + 1) * this.tileWidth), (float)((float)sy * this.tileHeight + this.tileHeight));
        GL11.glVertex2f((float)(x + tw), (float)(y + th));
        GL11.glTexCoord2f((float)((float)(sx + 1) * this.tileWidth), (float)((float)sy * this.tileHeight));
        GL11.glVertex2f((float)(x + tw), (float)y);
    }

    public void draw(int x, int y, int sx, int sy, Color top, Color bottom) {
        this.texture.bind();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glBegin((int)7);
        top.bind();
        GL11.glTexCoord2f((float)((float)sx * this.tileWidth), (float)((float)sy * this.tileHeight));
        GL11.glVertex2f((float)0.0f, (float)0.0f);
        bottom.bind();
        GL11.glTexCoord2f((float)((float)sx * this.tileWidth), (float)((float)sy * this.tileHeight + this.tileHeight));
        GL11.glVertex2f((float)0.0f, (float)this.th);
        GL11.glTexCoord2f((float)((float)(sx + 1) * this.tileWidth), (float)((float)sy * this.tileHeight + this.tileHeight));
        GL11.glVertex2f((float)this.tw, (float)this.th);
        top.bind();
        GL11.glTexCoord2f((float)((float)(sx + 1) * this.tileWidth), (float)((float)sy * this.tileHeight));
        GL11.glVertex2f((float)this.tw, (float)0.0f);
        GL11.glEnd();
        GL11.glTranslatef((float)(-x), (float)(-y), (float)0.0f);
    }
}

