/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.render.sprite;

import java.io.IOException;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;

public class Sprite {
    private Texture texture;
    private int width;
    private int height;
    private boolean flipx;

    public Sprite(String ref) {
        try {
            this.texture = TextureLoader.get().getTextureLinear(ref);
            this.width = this.texture.getImageWidth();
            this.height = this.texture.getImageHeight();
        }
        catch (IOException e) {
            System.err.println("Unable to load texture: " + ref);
            System.exit(0);
        }
    }

    public int getWidth() {
        return this.texture.getImageWidth();
    }

    public int getHeight() {
        return this.texture.getImageHeight();
    }

    public void setFlipX(boolean flip) {
        this.flipx = flip;
    }

    public void drawRotated(int x, int y, float angle) {
        this.texture.bind();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glRotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(-(this.width / 2)), (float)(-(this.height / 2)), (float)0.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)this.texture.getHeight());
        GL11.glVertex3f((float)0.0f, (float)this.height, (float)0.0f);
        GL11.glTexCoord2f((float)this.texture.getWidth(), (float)this.texture.getHeight());
        GL11.glVertex3f((float)this.width, (float)this.height, (float)0.0f);
        GL11.glTexCoord2f((float)this.texture.getWidth(), (float)0.0f);
        GL11.glVertex3f((float)this.width, (float)0.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glTranslatef((float)(this.width / 2), (float)(this.height / 2), (float)0.0f);
        GL11.glRotatef((float)(-angle), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(-x), (float)(-y), (float)0.0f);
    }

    public void draw(int x, int y) {
        this.texture.bind();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        float val = 0.0f;
        if (this.flipx) {
            val = this.texture.getWidth();
        }
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)val, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)val, (float)this.texture.getHeight());
        GL11.glVertex3f((float)0.0f, (float)this.height, (float)0.0f);
        GL11.glTexCoord2f((float)(this.texture.getWidth() - val), (float)this.texture.getHeight());
        GL11.glVertex3f((float)this.width, (float)this.height, (float)0.0f);
        GL11.glTexCoord2f((float)(this.texture.getWidth() - val), (float)0.0f);
        GL11.glVertex3f((float)this.width, (float)0.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glTranslatef((float)(-x), (float)(-y), (float)0.0f);
    }
}

