/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.render.pick;

import org.newdawn.render.pick.Ray;
import org.newdawn.render.util.Tuple3;

public class Sphere {
    private Tuple3 center;
    private float radius;

    public Sphere(Tuple3 center, float radius) {
        this.center = center;
        this.radius = radius;
    }

    public void setCenter(float x, float y, float z) {
        this.center.x = x;
        this.center.y = y;
        this.center.z = z;
    }

    public Tuple3 intersect(Ray ray) {
        Tuple3 diff = ray.getStart().copy();
        diff.sub(this.center);
        float a = ray.getDirection().lengthSquared();
        float b = diff.dot(ray.getDirection());
        float c = diff.lengthSquared() - this.radius * this.radius;
        float[] t = new float[2];
        float discr = b * b - a * c;
        if ((double)discr < 0.0) {
            return null;
        }
        if ((double)discr > 0.0) {
            float root = (float)Math.sqrt(discr);
            float invA = 1.0f / a;
            t[0] = (-b - root) * invA;
            t[1] = (-b + root) * invA;
            if ((double)t[0] >= 0.0) {
                return ray.getPoint(t[0]);
            }
            if ((double)t[1] >= 0.0) {
                return ray.getPoint(t[1]);
            }
            return null;
        }
        t[0] = -b / a;
        if ((double)t[0] >= 0.0) {
            return ray.getPoint(t[0]);
        }
        return null;
    }
}

