/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.render.particles;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.particles.Affect;
import org.newdawn.render.particles.Emitter;
import org.newdawn.render.texture.Texture;

public class ParticleEngine
implements Comparator {
    private int count;
    private Texture texture;
    private Emitter emitter;
    private int nextParticle;
    private ArrayList effects = new ArrayList();
    private FloatBuffer mat = BufferUtils.createFloatBuffer((int)4);
    private int bright;
    private FloatBuffer vertices;
    private FloatBuffer colors;
    private FloatBuffer tex;
    private boolean vertexArray;
    private Particle[] particles;
    private ArrayList unused = new ArrayList();
    private ArrayList used = new ArrayList();
    private float[] verticesArray;
    private float[] colorsArray;
    private int zSortResult = -1;

    public ParticleEngine(int count, Texture texture, Emitter emitter, boolean bright, boolean vertexArray, int result) {
        int i;
        this.count = count;
        this.emitter = emitter;
        this.texture = texture;
        this.vertexArray = vertexArray;
        this.zSortResult = result;
        this.bright = bright ? 1 : 771;
        this.particles = new Particle[count];
        for (i = 0; i < this.particles.length; ++i) {
            this.particles[i] = new Particle(i);
            this.unused.add(this.particles[i]);
        }
        emitter.init(this);
        if (vertexArray) {
            this.zSortResult = -this.zSortResult;
            this.verticesArray = new float[count * 4 * 3];
            this.colorsArray = new float[count * 4 * 4];
            this.vertices = BufferUtils.createFloatBuffer((int)(count * 4 * 3));
            this.colors = BufferUtils.createFloatBuffer((int)(count * 4 * 4));
            this.tex = BufferUtils.createFloatBuffer((int)(count * 4 * 2));
            for (i = 0; i < count; ++i) {
                this.tex.put(0.0f).put(0.0f);
                this.tex.put(1.0f).put(0.0f);
                this.tex.put(1.0f).put(1.0f);
                this.tex.put(0.0f).put(1.0f);
            }
            this.tex.flip();
        }
    }

    public void addAffect(Affect affect) {
        this.effects.add(affect);
    }

    public void removeAffect(Affect affect) {
        this.effects.remove(affect);
    }

    public void update(int delta) {
        for (int i = this.used.size() - 1; i >= 0; --i) {
            Particle p = (Particle)this.used.get(i);
            p.life -= delta;
            if (p.life <= 0) {
                this.unused.add(this.used.remove(i--));
                continue;
            }
            for (int j = this.effects.size() - 1; j >= 0; --j) {
                ((Affect)this.effects.get(j)).updateParticle(p.id, delta, this, p.life);
            }
            p.move(delta);
        }
        this.emitter.update(delta, this);
    }

    public void render(int delta, boolean lit) {
        this.texture.bind();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)this.bright);
        this.quickSort(this.used);
        if (this.vertexArray) {
            this.vertices.clear();
            this.colors.clear();
            for (int i = this.used.size() - 1; i >= 0; --i) {
                Particle p = (Particle)this.used.get(i);
                int j = i * 12;
                this.verticesArray[j] = p.pos[0] - p.size;
                this.verticesArray[j + 1] = p.pos[1] - p.size;
                this.verticesArray[j + 2] = p.pos[2];
                this.verticesArray[j + 3] = p.pos[0] + p.size;
                this.verticesArray[j + 4] = p.pos[1] - p.size;
                this.verticesArray[j + 5] = p.pos[2];
                this.verticesArray[j + 6] = p.pos[0] + p.size;
                this.verticesArray[j + 7] = p.pos[1] + p.size;
                this.verticesArray[j + 8] = p.pos[2];
                this.verticesArray[j + 9] = p.pos[0] - p.size;
                this.verticesArray[j + 10] = p.pos[1] + p.size;
                this.verticesArray[j + 11] = p.pos[2];
                int k = i * 16;
                for (int l = 0; l < 4; ++l) {
                    this.colorsArray[k++] = p.col[0];
                    this.colorsArray[k++] = p.col[1];
                    this.colorsArray[k++] = p.col[2];
                    this.colorsArray[k++] = p.col[3];
                }
            }
            this.vertices.put(this.verticesArray, 0, this.used.size() * 12);
            this.colors.put(this.colorsArray, 0, this.used.size() * 16);
            this.vertices.flip();
            this.colors.flip();
            GL11.glEnableClientState((int)32884);
            GL11.glEnableClientState((int)32886);
            GL11.glEnableClientState((int)32888);
            GL11.glVertexPointer((int)3, (int)0, (FloatBuffer)this.vertices);
            GL11.glColorPointer((int)4, (int)0, (FloatBuffer)this.colors);
            GL11.glTexCoordPointer((int)2, (int)0, (FloatBuffer)this.tex);
            GL11.glDrawArrays((int)7, (int)0, (int)(this.used.size() * 4));
            GL11.glDisableClientState((int)32886);
        } else {
            GL11.glBegin((int)7);
            for (int i = this.used.size() - 1; i >= 0; --i) {
                Particle p = (Particle)this.used.get(i);
                if (lit) {
                    this.mat.clear();
                    this.mat.put(p.col[0]).put(p.col[1]).put(p.col[2]).put(p.col[3]);
                    this.mat.flip();
                    GL11.glMaterial((int)1032, (int)4609, (FloatBuffer)this.mat);
                } else {
                    GL11.glColor4f((float)p.col[0], (float)p.col[1], (float)p.col[2], (float)p.col[3]);
                }
                GL11.glTexCoord2f((float)0.0f, (float)0.0f);
                GL11.glVertex3f((float)(p.pos[0] - p.size), (float)(p.pos[1] - p.size), (float)p.pos[2]);
                GL11.glTexCoord2f((float)1.0f, (float)0.0f);
                GL11.glVertex3f((float)(p.pos[0] + p.size), (float)(p.pos[1] - p.size), (float)p.pos[2]);
                GL11.glTexCoord2f((float)1.0f, (float)1.0f);
                GL11.glVertex3f((float)(p.pos[0] + p.size), (float)(p.pos[1] + p.size), (float)p.pos[2]);
                GL11.glTexCoord2f((float)0.0f, (float)1.0f);
                GL11.glVertex3f((float)(p.pos[0] - p.size), (float)(p.pos[1] + p.size), (float)p.pos[2]);
            }
            GL11.glEnd();
        }
        GL11.glDisable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
    }

    public void adjustVelocity(int p, float x, float y, float z) {
        this.particles[p].vel[0] = this.particles[p].vel[0] + x;
        this.particles[p].vel[1] = this.particles[p].vel[1] + y;
        this.particles[p].vel[2] = this.particles[p].vel[2] + z;
    }

    public void scaleVelocity(int p, float x, float y, float z) {
        this.particles[p].vel[0] = this.particles[p].vel[0] * x;
        this.particles[p].vel[1] = this.particles[p].vel[1] * y;
        this.particles[p].vel[2] = this.particles[p].vel[2] * z;
    }

    public void setVelocity(int p, float x, float y, float z) {
        this.particles[p].vel[0] = x;
        this.particles[p].vel[1] = y;
        this.particles[p].vel[2] = z;
    }

    public void setPos(int p, float x, float y, float z) {
        this.particles[p].pos[0] = x;
        this.particles[p].pos[1] = y;
        this.particles[p].pos[2] = z;
    }

    public void setSize(int p, float s) {
        this.particles[p].size = s;
    }

    public void adjustSize(int p, float s) {
        this.particles[p].size += s;
    }

    public void adjustColor(int p, float r, float g, float b, float a) {
        this.particles[p].col[0] = this.particles[p].col[0] + r;
        this.particles[p].col[1] = this.particles[p].col[1] + g;
        this.particles[p].col[2] = this.particles[p].col[2] + b;
        this.particles[p].col[3] = this.particles[p].col[3] + a;
    }

    public void setColor(int p, float r, float g, float b, float a) {
        this.particles[p].col[0] = r;
        this.particles[p].col[1] = g;
        this.particles[p].col[2] = b;
        this.particles[p].col[3] = a;
    }

    public int getParticleCount() {
        return this.used.size();
    }

    public int getParticle(int l) {
        if (this.unused.size() == 0) {
            return -1;
        }
        Particle p = (Particle)this.unused.remove(0);
        this.used.add(p);
        p.life = l;
        return p.id;
    }

    public float getX(int p) {
        return this.particles[p].pos[0];
    }

    public float getY(int p) {
        return this.particles[p].pos[1];
    }

    public float getZ(int p) {
        return this.particles[p].pos[2];
    }

    public float getLife(int p) {
        return this.particles[p].life;
    }

    public int compare(Object a, Object b) {
        Particle p1 = (Particle)a;
        Particle p2 = (Particle)b;
        float result = p1.pos[2] - p2.pos[2];
        if (result == 0.0f) {
            return 0;
        }
        if (result < 0.0f) {
            return this.zSortResult;
        }
        return -this.zSortResult;
    }

    private void quickSort(ArrayList elements) {
        if (elements.size() < 2) {
            return;
        }
        this.quickSort(elements, 0, elements.size() - 1);
    }

    private void quickSort(ArrayList elements, int lowIndex, int highIndex) {
        int lowToHighIndex = lowIndex;
        int highToLowIndex = highIndex;
        int pivotIndex = (lowToHighIndex + highToLowIndex) / 2;
        Object pivotValue = elements.get(pivotIndex);
        int newLowIndex = highIndex + 1;
        int newHighIndex = lowIndex - 1;
        while (newHighIndex + 1 < newLowIndex) {
            int compareResult;
            Object lowToHighValue = elements.get(lowToHighIndex);
            while (lowToHighIndex < newLowIndex & this.compare(lowToHighValue, pivotValue) < 0) {
                newHighIndex = lowToHighIndex++;
                lowToHighValue = elements.get(lowToHighIndex);
            }
            Object highToLowValue = elements.get(highToLowIndex);
            while (newHighIndex <= highToLowIndex & this.compare(highToLowValue, pivotValue) > 0) {
                newLowIndex = highToLowIndex--;
                highToLowValue = elements.get(highToLowIndex);
            }
            if (lowToHighIndex == highToLowIndex) {
                newHighIndex = lowToHighIndex;
                continue;
            }
            if (lowToHighIndex >= highToLowIndex || (compareResult = this.compare(lowToHighValue, highToLowValue)) < 0) continue;
            Object parking = lowToHighValue;
            elements.set(lowToHighIndex, highToLowValue);
            elements.set(highToLowIndex, parking);
            newLowIndex = highToLowIndex--;
            newHighIndex = lowToHighIndex++;
        }
        if (lowIndex < newHighIndex) {
            this.quickSort(elements, lowIndex, newHighIndex);
        }
        if (newLowIndex < highIndex) {
            this.quickSort(elements, newLowIndex, highIndex);
        }
    }

    private class Particle {
        public int id;
        public float[] pos = new float[3];
        public float[] vel = new float[3];
        public float[] col = new float[4];
        public float size;
        public int life;

        public Particle(int id) {
            this.id = id;
        }

        public void move(int delta) {
            this.pos[0] = this.pos[0] + this.vel[0] * (float)delta / 1000.0f;
            this.pos[1] = this.pos[1] + this.vel[1] * (float)delta / 1000.0f;
            this.pos[2] = this.pos[2] + this.vel[2] * (float)delta / 1000.0f;
        }
    }
}

