/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.render.particles;

import org.newdawn.render.particles.Affect;
import org.newdawn.render.particles.Emitter;
import org.newdawn.render.particles.ParticleEngine;

public class FireEmitter
implements Emitter,
Affect {
    private int interval = 25;
    private int countDown;

    public void update(int delta, ParticleEngine engine) {
        int remainder = delta;
        while (remainder > this.countDown) {
            remainder -= this.countDown;
            int index = engine.getParticle(1000);
            if (index != -1) {
                engine.setColor(index, 1.0f, 1.0f, 1.0f, 1.0f);
                engine.setPos(index, 0.0f, 0.0f, 0.0f);
                engine.setVelocity(index, (float)(Math.random() * (double)-0.1f) + 0.05f, (float)(Math.random() * 0.25), (float)(Math.random() * (double)-0.1f) + 0.05f);
                engine.setSize(index, 0.05f);
            }
            this.countDown = this.interval;
        }
        this.countDown -= remainder;
    }

    public void init(ParticleEngine engine) {
        engine.addAffect(this);
    }

    public void updateParticle(int i, int delta, ParticleEngine engine, int life) {
        engine.adjustSize(i, (float)delta * 0.01f / 1000.0f);
        float y = engine.getY(i);
        engine.setColor(i, 1.0f, engine.getLife(i) / 3000.0f + 0.3f, engine.getLife(i) / 3000.0f, engine.getLife(i) / 1000.0f);
    }
}

