/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.render.models.obj;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.newdawn.render.models.obj.Face;
import org.newdawn.render.util.Tuple2;
import org.newdawn.render.util.Tuple3;
import org.newdawn.util.Log;

public class ObjData {
    private ArrayList verts = new ArrayList();
    private ArrayList normals = new ArrayList();
    private ArrayList texCoords = new ArrayList();
    private ArrayList faces = new ArrayList();

    public ObjData(InputStream in) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        while (reader.ready() && (line = reader.readLine()) != null) {
            if (line.startsWith("vn")) {
                Tuple3 normal = this.readTuple3(line);
                this.normals.add(normal);
                continue;
            }
            if (line.startsWith("vt")) {
                Tuple2 tex = this.readTuple2(line);
                this.texCoords.add(tex);
                continue;
            }
            if (line.startsWith("v")) {
                Tuple3 vert = this.readTuple3(line);
                this.verts.add(vert);
                continue;
            }
            if (!line.startsWith("f")) continue;
            Face face = this.readFace(line);
            this.faces.add(face);
        }
        Log.log((String)("Read " + this.verts.size() + " verticies"));
        Log.log((String)("Read " + this.faces.size() + " faces"));
    }

    public int getFaceCount() {
        return this.faces.size();
    }

    public Face getFace(int index) {
        return (Face)this.faces.get(index);
    }

    private Tuple3 readTuple3(String line) throws IOException {
        StringTokenizer tokens = new StringTokenizer(line, " ");
        tokens.nextToken();
        try {
            float x = Float.parseFloat(tokens.nextToken());
            float y = Float.parseFloat(tokens.nextToken());
            float z = Float.parseFloat(tokens.nextToken());
            return new Tuple3(x, y, z);
        }
        catch (NumberFormatException e) {
            throw new IOException(e.getMessage());
        }
    }

    private Tuple2 readTuple2(String line) throws IOException {
        StringTokenizer tokens = new StringTokenizer(line, " ");
        tokens.nextToken();
        try {
            float x = Float.parseFloat(tokens.nextToken());
            float y = Float.parseFloat(tokens.nextToken());
            return new Tuple2(x, y);
        }
        catch (NumberFormatException e) {
            throw new IOException(e.getMessage());
        }
    }

    private Face readFace(String line) throws IOException {
        StringTokenizer points = new StringTokenizer(line, " ");
        points.nextToken();
        int faceCount = points.countTokens();
        if (faceCount != 3) {
            throw new RuntimeException("Only triangles are supported: " + line);
        }
        Face face = new Face(faceCount);
        try {
            for (int i = 0; i < faceCount; ++i) {
                StringTokenizer parts = new StringTokenizer(points.nextToken(), "/");
                int v = Integer.parseInt(parts.nextToken());
                int t = Integer.parseInt(parts.nextToken());
                int n = Integer.parseInt(parts.nextToken());
                face.addPoint((Tuple3)this.verts.get(v - 1), (Tuple2)this.texCoords.get(t - 1), (Tuple3)this.normals.get(n - 1));
            }
        }
        catch (NumberFormatException e) {
            throw new IOException(e.getMessage());
        }
        return face;
    }
}

