/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.render.models.md3;

import org.lwjgl.opengl.GL11;
import org.newdawn.render.buffer.BufferFactory;
import org.newdawn.render.buffer.IndexedTriangleBuffer;
import org.newdawn.render.buffer.RenderableBuffer;
import org.newdawn.render.buffer.TriangleBuffer;
import org.newdawn.render.models.md3.MD3Mesh;

public class MD3Model {
    private RenderableBuffer[] meshes;
    private int frameCount;
    private int meshCount;
    private boolean indexed;

    MD3Model(int meshCount) {
        this.meshCount = meshCount;
        this.meshes = new RenderableBuffer[meshCount];
    }

    void addMesh(int meshIndex, MD3Mesh mesh, boolean indexed) {
        this.indexed = indexed;
        this.frameCount = mesh.getFrameCount();
        this.buildMesh(meshIndex, mesh, indexed);
    }

    public void refresh() {
        throw new RuntimeException("Unsupported");
    }

    void buildMesh(int meshIndex, MD3Mesh mesh, boolean indexed) {
        if (indexed) {
            IndexedTriangleBuffer buffer = BufferFactory.createIndexedTriangleBuffer();
            for (int i = 0; i < mesh.getFrameCount(); ++i) {
                mesh.renderIndexedFrame(buffer, i);
            }
            buffer.commit();
            this.meshes[meshIndex] = buffer;
        } else {
            TriangleBuffer buffer = BufferFactory.createTriangleBuffer();
            for (int i = 0; i < mesh.getFrameCount(); ++i) {
                mesh.renderFrame(buffer, i);
            }
            buffer.commit();
            this.meshes[meshIndex] = buffer;
        }
    }

    public void release() {
        for (int i = 0; i < this.meshCount; ++i) {
            this.meshes[i].release();
        }
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public void renderFrame(int frameIndex) {
        frameIndex %= this.frameCount - 1;
        float scale = 0.015625f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        for (int meshIndex = 0; meshIndex < this.meshCount; ++meshIndex) {
            this.meshes[meshIndex].render(frameIndex);
        }
        GL11.glScalef((float)64.0f, (float)64.0f, (float)64.0f);
    }
}

