/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.render.models.md3;

import java.io.IOException;
import org.newdawn.render.buffer.IndexedTriangleBuffer;
import org.newdawn.render.buffer.TriangleBuffer;
import org.newdawn.render.models.cio.LittleEndianDataInputStream;
import org.newdawn.render.models.md3.MD3Mesh;
import org.newdawn.render.util.Tuple2;
import org.newdawn.render.util.Tuple3;

public class MD3MeshFrame {
    public static final float SCALE = 0.015625f;
    private float[][] verts;
    private float[][] norms;
    private MD3Mesh mesh;

    public MD3MeshFrame(MD3Mesh mesh, LittleEndianDataInputStream in) throws IOException {
        int vertexNum = mesh.getVertexNum();
        this.mesh = mesh;
        this.verts = new float[vertexNum][3];
        this.norms = new float[vertexNum][3];
        byte[][] env = new byte[vertexNum][2];
        for (int i = 0; i < vertexNum; ++i) {
            this.verts[i][0] = (float)in.readShort() * 0.015625f;
            this.verts[i][1] = (float)in.readShort() * 0.015625f;
            this.verts[i][2] = (float)in.readShort() * 0.015625f;
            int lat = in.readUnsignedByte();
            int lng = in.readUnsignedByte();
            float newlat = (float)((double)lat * Math.PI / 128.0);
            float newlng = (float)((double)lng * Math.PI / 128.0);
            this.norms[i][0] = (float)(Math.cos(newlat) * Math.sin(newlng));
            this.norms[i][1] = (float)(Math.sin(newlat) * Math.sin(newlng));
            this.norms[i][2] = (float)Math.cos(newlng);
        }
    }

    public int renderIndexed(int offset, IndexedTriangleBuffer buffer, int[][] tris, float[][] uv) {
        int i;
        int id = buffer.startSet();
        int count = this.mesh.getTriangleCount();
        int vertCount = this.mesh.getVertexNum();
        for (i = 0; i < vertCount; ++i) {
            buffer.addPoint(new Tuple3(this.verts[i][0], this.verts[i][1], this.verts[i][2]), new Tuple3(this.norms[i][0], this.norms[i][1], this.norms[i][2]), new Tuple2(uv[i][0], uv[i][1]));
        }
        for (i = 0; i < count; ++i) {
            buffer.addPointIndex(tris[i][0] + offset);
            buffer.addPointIndex(tris[i][1] + offset);
            buffer.addPointIndex(tris[i][2] + offset);
        }
        buffer.endSet();
        return id;
    }

    public int render(TriangleBuffer buffer, int[][] tris, float[][] uv) {
        int id = buffer.startSet();
        int count = this.mesh.getTriangleCount();
        for (int i = 0; i < count; ++i) {
            Tuple3 p1 = new Tuple3(this.verts[tris[i][0]][0], this.verts[tris[i][0]][1], this.verts[tris[i][0]][2]);
            Tuple3 p2 = new Tuple3(this.verts[tris[i][1]][0], this.verts[tris[i][1]][1], this.verts[tris[i][1]][2]);
            Tuple3 p3 = new Tuple3(this.verts[tris[i][2]][0], this.verts[tris[i][2]][1], this.verts[tris[i][2]][2]);
            Tuple3 n1 = new Tuple3(this.norms[tris[i][0]][0], this.norms[tris[i][0]][1], this.norms[tris[i][0]][2]);
            Tuple3 n2 = new Tuple3(this.norms[tris[i][1]][0], this.norms[tris[i][1]][1], this.norms[tris[i][1]][2]);
            Tuple3 n3 = new Tuple3(this.norms[tris[i][2]][0], this.norms[tris[i][2]][1], this.norms[tris[i][2]][2]);
            buffer.addPoint(p1, n1, new Tuple2(uv[tris[i][0]][0], uv[tris[i][0]][1]));
            buffer.addPoint(p2, n2, new Tuple2(uv[tris[i][1]][0], uv[tris[i][1]][1]));
            buffer.addPoint(p3, n3, new Tuple2(uv[tris[i][2]][0], uv[tris[i][2]][1]));
        }
        buffer.endSet();
        return id;
    }
}

