/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.render.models.md3;

import java.io.IOException;
import org.newdawn.render.buffer.IndexedTriangleBuffer;
import org.newdawn.render.buffer.TriangleBuffer;
import org.newdawn.render.models.cio.LittleEndianDataInputStream;
import org.newdawn.render.models.cio.Util;
import org.newdawn.render.models.md3.MD3Header;
import org.newdawn.render.models.md3.MD3MeshFrame;
import org.newdawn.util.Log;

public class MD3Mesh {
    private String ID;
    private String name;
    private int meshFrameNum;
    private int skinNum;
    private int vertexNum;
    private int triangleNum;
    private int triangleStart;
    private int textureStart;
    private int texVecStart;
    private int vertexStart;
    private int meshSize;
    private int[][] tris;
    private String[] skins;
    private float[][] uv;
    private MD3MeshFrame[] frames;

    public MD3Mesh(int mesh, MD3Header header, LittleEndianDataInputStream in) throws IOException {
        boolean verts;
        this.ID = Util.readString(in, 4);
        this.name = Util.readString(in, 68);
        this.meshFrameNum = in.readInt();
        this.skinNum = in.readInt();
        this.vertexNum = in.readInt();
        this.triangleNum = in.readInt();
        this.triangleStart = in.readInt();
        int headerSize = in.readInt();
        this.texVecStart = in.readInt();
        this.vertexStart = in.readInt();
        this.meshSize = in.readInt();
        int byteCount = 108;
        boolean skins = headerSize == 0;
        boolean triangles = this.triangleStart == 0;
        boolean texmap = this.texVecStart == 0;
        boolean bl = verts = this.vertexStart == 0;
        while (!(skins && triangles && texmap && verts)) {
            if (byteCount == headerSize && !skins) {
                this.readSkins(in);
                byteCount += this.skinNum * 68;
                skins = true;
                continue;
            }
            if (byteCount == this.triangleStart && !triangles) {
                this.readTriangles(in);
                byteCount += this.triangleNum * 12;
                triangles = true;
                continue;
            }
            if (byteCount == this.texVecStart && !texmap) {
                this.readTexMap(in);
                byteCount += this.vertexNum * 8;
                texmap = true;
                continue;
            }
            if (byteCount == this.vertexStart && !verts) {
                this.readVerts(in);
                byteCount += this.meshFrameNum * this.vertexNum * 8;
                verts = true;
                continue;
            }
            Log.log((String)"Invalid MD3");
            throw new IOException("Invalid MD3");
        }
    }

    private void readSkins(LittleEndianDataInputStream in) throws IOException {
        this.skins = new String[this.skinNum];
        for (int i = 0; i < this.skinNum; ++i) {
            this.skins[i] = Util.readString(in, 68);
        }
    }

    private void readTriangles(LittleEndianDataInputStream in) throws IOException {
        this.tris = new int[this.triangleNum][3];
        for (int i = 0; i < this.triangleNum; ++i) {
            this.tris[i][0] = in.readInt();
            this.tris[i][1] = in.readInt();
            this.tris[i][2] = in.readInt();
        }
    }

    private void readTexMap(LittleEndianDataInputStream in) throws IOException {
        this.uv = new float[this.vertexNum][2];
        for (int i = 0; i < this.vertexNum; ++i) {
            this.uv[i][0] = in.readFloat();
            this.uv[i][1] = in.readFloat();
        }
    }

    private void readVerts(LittleEndianDataInputStream in) throws IOException {
        this.frames = new MD3MeshFrame[this.meshFrameNum];
        for (int i = 0; i < this.meshFrameNum; ++i) {
            this.frames[i] = new MD3MeshFrame(this, in);
        }
    }

    public int getVertexNum() {
        return this.vertexNum;
    }

    public int getFrameCount() {
        return this.meshFrameNum;
    }

    public int getTriangleCount() {
        return this.triangleNum;
    }

    public String getName() {
        return this.name;
    }

    public int renderFrame(TriangleBuffer buffer, int frame) {
        return this.frames[frame].render(buffer, this.tris, this.uv);
    }

    public int renderIndexedFrame(IndexedTriangleBuffer buffer, int frame) {
        return this.frames[frame].renderIndexed(this.vertexNum * frame, buffer, this.tris, this.uv);
    }
}

