/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.render.models.md3;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.newdawn.render.models.cio.LittleEndianDataInputStream;
import org.newdawn.render.models.md3.MD3Header;
import org.newdawn.render.models.md3.MD3Mesh;
import org.newdawn.render.models.md3.MD3Model;
import org.newdawn.util.Log;
import org.newdawn.util.ResourceLoader;

public class MD3Loader {
    public static MD3Model loadFromFile(File ref, boolean indexed) throws IOException {
        Log.log((String)("Loading MD3 " + ref));
        FileInputStream in = new FileInputStream(ref);
        MD3Header header = MD3Loader.readHeader(in);
        ((InputStream)in).close();
        in = new FileInputStream(ref);
        MD3Model model = MD3Loader.readMeshs(in, header, indexed);
        ((InputStream)in).close();
        return model;
    }

    public static MD3Model loadFromClasspath(String ref, boolean indexed) throws IOException {
        URL url = ResourceLoader.getResource((String)ref);
        int total = url.openConnection().getContentLength();
        byte[] data = new byte[total];
        InputStream datain = ResourceLoader.getResourceAsStream((String)ref);
        datain.read(data, 0, total);
        Log.log((String)("Loading MD3 " + ref + " (" + total + ")"));
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        MD3Header header = MD3Loader.readHeader(in);
        ((InputStream)in).close();
        in = new ByteArrayInputStream(data);
        MD3Model model = MD3Loader.readMeshs(in, header, indexed);
        ((InputStream)in).close();
        return model;
    }

    private static MD3Model readMeshs(InputStream in, MD3Header header, boolean indexed) throws IOException {
        LittleEndianDataInputStream din = new LittleEndianDataInputStream(new DataInputStream(in));
        header.skipToMeshs(din);
        MD3Model model = new MD3Model(header.getMeshCount());
        for (int i = 0; i < header.getMeshCount(); ++i) {
            MD3Mesh mesh = new MD3Mesh(i, header, din);
            model.addMesh(i, mesh, indexed);
        }
        return model;
    }

    private static MD3Header readHeader(InputStream in) throws IOException {
        LittleEndianDataInputStream din = new LittleEndianDataInputStream(new DataInputStream(in));
        MD3Header header = new MD3Header(din);
        din.close();
        return header;
    }
}

