/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.render.models.md3;

import java.io.IOException;
import org.newdawn.render.models.cio.LittleEndianDataInputStream;
import org.newdawn.render.models.cio.Util;
import org.newdawn.render.util.Tuple3;

public class MD3Header {
    private byte[] ID = new byte[4];
    private int version;
    private String filename;
    private int boneFrameNum;
    private int tagNum;
    private int meshNum;
    private int maxSkinNum;
    private int headerLength;
    private int fileSize;
    private int tagStart;
    private int tagEnd;

    public MD3Header(LittleEndianDataInputStream in) throws IOException {
        in.readFully(this.ID);
        this.version = in.readInt();
        this.filename = Util.readString(in, 68);
        this.boneFrameNum = in.readInt();
        this.tagNum = in.readInt();
        this.meshNum = in.readInt();
        this.maxSkinNum = in.readInt();
        this.headerLength = in.readInt();
        this.tagStart = in.readInt();
        this.tagEnd = in.readInt();
        this.fileSize = in.readInt();
        in.skipBytes(this.tagStart - 108);
        int tagCount = this.tagNum;
        for (int k = 0; k < this.boneFrameNum; ++k) {
            for (int i = 0; i < tagCount; ++i) {
                String tagName = Util.readString(in, 64);
                Tuple3 trans = new Tuple3(in.readFloat(), in.readFloat(), in.readFloat());
                float m00 = in.readFloat();
                float m10 = in.readFloat();
                float m20 = in.readFloat();
                float m01 = in.readFloat();
                float m11 = in.readFloat();
                float m21 = in.readFloat();
                float m02 = in.readFloat();
                float m12 = in.readFloat();
                float m22 = in.readFloat();
            }
        }
    }

    public void skipToMeshs(LittleEndianDataInputStream in) throws IOException {
        in.skipBytes(this.tagEnd);
    }

    public int getMeshCount() {
        return this.meshNum;
    }

    public int getMeshStart() {
        return this.tagEnd;
    }
}

