/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.render.models.md2;

import java.io.IOException;
import org.newdawn.render.buffer.BufferFactory;
import org.newdawn.render.buffer.TriangleBuffer;
import org.newdawn.render.models.cio.LittleEndianDataInputStream;
import org.newdawn.render.models.md2.MD2Faces;
import org.newdawn.render.models.md2.MD2Header;
import org.newdawn.render.models.md2.MD2Normals;
import org.newdawn.render.models.md2.MD2TextureCoordinates;
import org.newdawn.render.util.Bounds;
import org.newdawn.render.util.Tuple2;
import org.newdawn.render.util.Tuple3;

public class MD2Model {
    private TriangleBuffer[] frames;
    private Bounds[] bounds;

    public MD2Model(LittleEndianDataInputStream in, MD2Header header, MD2Faces faces, MD2TextureCoordinates tex, String[] frameNames) throws IOException {
        this.frames = new TriangleBuffer[header.getFrameCount()];
        this.bounds = new Bounds[header.getFrameCount()];
        for (int i = 0; i < header.getFrameCount(); ++i) {
            int j;
            float sx = in.readFloat();
            float sy = in.readFloat();
            float sz = in.readFloat();
            float tx = in.readFloat();
            float ty = in.readFloat();
            float tz = in.readFloat();
            byte[] nameBytes = new byte[16];
            in.readFully(nameBytes);
            boolean found = true;
            if (frameNames != null) {
                String name = new String(nameBytes);
                found = false;
                for (int j2 = 0; j2 < frameNames.length; ++j2) {
                    if (!name.startsWith(frameNames[j2])) continue;
                    found = true;
                }
            }
            if (found) {
                this.frames[i] = BufferFactory.createTriangleBuffer();
                this.frames[i].startSet();
                this.bounds[i] = new Bounds();
            }
            float[][] vertData = new float[header.getVertCount()][3];
            int[] normData = new int[header.getVertCount()];
            for (j = 0; j < header.getVertCount(); ++j) {
                vertData[j][0] = (float)in.readUnsignedByte() * sx + tx;
                vertData[j][1] = (float)in.readUnsignedByte() * sy + ty;
                vertData[j][2] = (float)in.readUnsignedByte() * sz + tz;
                if (found) {
                    this.bounds[i].add(vertData[j][0], vertData[j][1], vertData[j][2]);
                }
                normData[j] = in.readUnsignedByte();
            }
            for (j = 0; j < header.getFaceCount(); ++j) {
                for (int k = 2; k >= 0; --k) {
                    int v = faces.getVertexIndex(j, k);
                    int t = faces.getTexIndex(j, k);
                    Tuple3 vert = new Tuple3(vertData[v][0], vertData[v][1], vertData[v][2]);
                    Tuple2 text = new Tuple2(tex.getU(t), tex.getV(t));
                    Tuple3 norm = new Tuple3(MD2Normals.data[normData[v]]);
                    if (!found) continue;
                    this.frames[i].addPoint(vert, norm, text);
                }
            }
            if (!found) continue;
            this.frames[i].endSet();
            this.frames[i].commit();
            this.bounds[i].rationalise();
        }
    }

    public Bounds getRoughBounds(int frame) {
        return this.bounds[frame];
    }

    public void renderFrame(int index) {
        this.frames[index].render(0);
    }

    public int getFrameCount() {
        return this.frames.length;
    }

    private String getName(byte[] line) {
        int index = line.length;
        for (int i = 0; i < line.length; ++i) {
            if (line[i] != 0) continue;
            index = i;
            break;
        }
        return new String(line, 0, index);
    }
}

