/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.render.models.md2;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.newdawn.render.models.cio.LittleEndianDataInputStream;
import org.newdawn.render.models.md2.MD2Anim;
import org.newdawn.render.models.md2.MD2Faces;
import org.newdawn.render.models.md2.MD2Header;
import org.newdawn.render.models.md2.MD2InterpolatedModel;
import org.newdawn.render.models.md2.MD2Model;
import org.newdawn.render.models.md2.MD2TextureCoordinates;
import org.newdawn.util.Log;
import org.newdawn.util.ResourceLoader;

public class MD2Loader {
    public static MD2InterpolatedModel loadInterpolated(String ref, MD2Anim[] anims, int[] steps) throws IOException {
        URL url = ResourceLoader.getResource((String)ref);
        int total = url.openConnection().getContentLength();
        byte[] data = new byte[total];
        InputStream datain = ResourceLoader.getResourceAsStream((String)ref);
        datain.read(data, 0, total);
        Log.log((String)("Loading Interpolated MD2 " + ref + " (" + total + ")"));
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        MD2Header header = MD2Loader.readHeader(in);
        ((InputStream)in).close();
        in = new ByteArrayInputStream(data);
        MD2Faces faces = MD2Loader.readFaces(in, header);
        ((InputStream)in).close();
        in = new ByteArrayInputStream(data);
        MD2TextureCoordinates tex = MD2Loader.readTex(in, header);
        ((InputStream)in).close();
        in = new ByteArrayInputStream(data);
        MD2InterpolatedModel model = MD2Loader.readModel(in, header, faces, tex, anims, steps);
        ((InputStream)in).close();
        return model;
    }

    public static MD2Model load(String ref) throws IOException {
        return MD2Loader.load(ref, null);
    }

    public static MD2Model load(String ref, String[] framePrefixes) throws IOException {
        URL url = ResourceLoader.getResource((String)ref);
        int total = url.openConnection().getContentLength();
        byte[] data = new byte[total];
        InputStream datain = ResourceLoader.getResourceAsStream((String)ref);
        datain.read(data, 0, total);
        Log.log((String)("Loading MD2 " + ref + " (" + total + ")"));
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        MD2Header header = MD2Loader.readHeader(in);
        ((InputStream)in).close();
        in = new ByteArrayInputStream(data);
        MD2Faces faces = MD2Loader.readFaces(in, header);
        ((InputStream)in).close();
        in = new ByteArrayInputStream(data);
        MD2TextureCoordinates tex = MD2Loader.readTex(in, header);
        ((InputStream)in).close();
        in = new ByteArrayInputStream(data);
        MD2Model model = MD2Loader.readModel(in, header, faces, tex, framePrefixes);
        ((InputStream)in).close();
        return model;
    }

    private static MD2TextureCoordinates readTex(InputStream in, MD2Header header) throws IOException {
        LittleEndianDataInputStream din = new LittleEndianDataInputStream(new DataInputStream(in));
        din.skip(header.getTexOffset());
        MD2TextureCoordinates tex = new MD2TextureCoordinates(din, header.getTexCount(), header.getTextureWidth(), header.getTextureHeight());
        din.close();
        return tex;
    }

    private static MD2Faces readFaces(InputStream in, MD2Header header) throws IOException {
        LittleEndianDataInputStream din = new LittleEndianDataInputStream(new DataInputStream(in));
        din.skip(header.getFacesOffset());
        MD2Faces faces = new MD2Faces(din, header.getFaceCount());
        din.close();
        return faces;
    }

    private static MD2Model readModel(InputStream in, MD2Header header, MD2Faces faces, MD2TextureCoordinates tex, String[] framePrefixes) throws IOException {
        LittleEndianDataInputStream din = new LittleEndianDataInputStream(new DataInputStream(in));
        din.skip(header.getFrameOffset());
        MD2Model model = new MD2Model(din, header, faces, tex, framePrefixes);
        din.close();
        return model;
    }

    private static MD2InterpolatedModel readModel(InputStream in, MD2Header header, MD2Faces faces, MD2TextureCoordinates tex, MD2Anim[] anims, int[] steps) throws IOException {
        LittleEndianDataInputStream din = new LittleEndianDataInputStream(new DataInputStream(in));
        din.skip(header.getFrameOffset());
        MD2InterpolatedModel model = new MD2InterpolatedModel(din, header, faces, tex, anims, steps);
        din.close();
        return model;
    }

    private static MD2Header readHeader(InputStream in) throws IOException {
        LittleEndianDataInputStream din = new LittleEndianDataInputStream(new DataInputStream(in));
        MD2Header header = new MD2Header(din);
        din.close();
        return header;
    }
}

