/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.render.models.md2;

import java.io.IOException;
import org.newdawn.render.buffer.BufferFactory;
import org.newdawn.render.buffer.TriangleBuffer;
import org.newdawn.render.models.cio.LittleEndianDataInputStream;
import org.newdawn.render.models.md2.MD2Anim;
import org.newdawn.render.models.md2.MD2Faces;
import org.newdawn.render.models.md2.MD2Header;
import org.newdawn.render.models.md2.MD2Normals;
import org.newdawn.render.models.md2.MD2TextureCoordinates;
import org.newdawn.render.util.Tuple2;
import org.newdawn.render.util.Tuple3;

public class MD2InterpolatedModel {
    private TriangleBuffer[][] frames;
    private int[] steps;

    public MD2InterpolatedModel(LittleEndianDataInputStream in, MD2Header header, MD2Faces faces, MD2TextureCoordinates tex, MD2Anim[] anims, int[] steps) throws IOException {
        int i;
        this.frames = new TriangleBuffer[header.getFrameCount()][];
        this.steps = new int[header.getFrameCount()];
        float[][][] vertData = new float[header.getFrameCount()][header.getVertCount()][3];
        int[][] normData = new int[header.getFrameCount()][header.getVertCount()];
        String[] names = new String[header.getFrameCount()];
        for (i = 0; i < header.getFrameCount(); ++i) {
            String name;
            float sx = in.readFloat();
            float sy = in.readFloat();
            float sz = in.readFloat();
            float tx = in.readFloat();
            float ty = in.readFloat();
            float tz = in.readFloat();
            byte[] nameBytes = new byte[16];
            in.readFully(nameBytes);
            boolean found = true;
            names[i] = name = new String(nameBytes);
            for (int j = 0; j < header.getVertCount(); ++j) {
                vertData[i][j][0] = (float)in.readUnsignedByte() * sx + tx;
                vertData[i][j][1] = (float)in.readUnsignedByte() * sy + ty;
                vertData[i][j][2] = (float)in.readUnsignedByte() * sz + tz;
                normData[i][j] = in.readUnsignedByte();
            }
        }
        for (i = 0; i < header.getFrameCount(); ++i) {
            int step;
            MD2Anim anim = this.requiredFrame(i, anims);
            if (anim == null) continue;
            int firstFrame = i;
            int secondFrame = anim.getNextFrame(firstFrame);
            int animIndex = 0;
            for (int k = 0; k < anims.length; ++k) {
                if (!anims[k].contains(i)) continue;
                animIndex = k;
            }
            this.steps[i] = step = steps[animIndex];
            this.frames[i] = new TriangleBuffer[step];
            for (int f = 0; f < step; ++f) {
                this.frames[i][f] = BufferFactory.createTriangleBuffer();
                this.frames[i][f].startSet();
                float firstWeight = 1.0f - (float)f * (1.0f / (float)step);
                float secondWeight = 1.0f - firstWeight;
                for (int j = 0; j < header.getFaceCount(); ++j) {
                    for (int k = 2; k >= 0; --k) {
                        int v = faces.getVertexIndex(j, k);
                        int t = faces.getTexIndex(j, k);
                        Tuple3 vert = new Tuple3(vertData[firstFrame][v][0] * firstWeight, vertData[firstFrame][v][1] * firstWeight, vertData[firstFrame][v][2] * firstWeight);
                        vert.add(new Tuple3(vertData[secondFrame][v][0] * secondWeight, vertData[secondFrame][v][1] * secondWeight, vertData[secondFrame][v][2] * secondWeight));
                        Tuple2 text = new Tuple2(tex.getU(t), tex.getV(t));
                        Tuple3 norm1 = new Tuple3(MD2Normals.data[normData[firstFrame][v]]);
                        Tuple3 norm2 = new Tuple3(MD2Normals.data[normData[secondFrame][v]]);
                        norm1.scale(firstWeight);
                        norm2.scale(secondWeight);
                        Tuple3 norm = new Tuple3(norm1);
                        norm.add(norm2);
                        this.frames[i][f].addPoint(vert, norm, text);
                    }
                }
                this.frames[i][f].endSet();
                this.frames[i][f].commit();
            }
        }
    }

    private MD2Anim requiredFrame(int index, MD2Anim[] anims) {
        for (int i = 0; i < anims.length; ++i) {
            if (!anims[i].contains(index)) continue;
            return anims[i];
        }
        return null;
    }

    public void renderFrame(int index, float delta) {
        int interpolation = (int)((float)this.steps[index] * delta);
        this.frames[index][interpolation].render(0);
    }

    public int getFrameCount() {
        return this.frames.length;
    }

    private String getName(byte[] line) {
        int index = line.length;
        for (int i = 0; i < line.length; ++i) {
            if (line[i] != 0) continue;
            index = i;
            break;
        }
        return new String(line, 0, index);
    }
}

