/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.render.models.md2;

import java.io.IOException;
import org.newdawn.render.models.cio.LittleEndianDataInputStream;

public class MD2Header {
    private int magic;
    private int version;
    private int skinWidth;
    private int skinHeight;
    private int frameSize;
    private int numSkins;
    private int numVertices;
    private int numTexcoords;
    private int numTriangles;
    private int numGlCommands;
    private int numFrames;
    private int offsetSkins;
    private int offsetTexcoords;
    private int offsetTriangles;
    private int offsetFrames;
    private int offsetGlCommands;
    private int offsetEnd;

    public MD2Header(LittleEndianDataInputStream in) throws IOException {
        this.magic = in.readInt();
        this.version = in.readInt();
        this.skinWidth = in.readInt();
        this.skinHeight = in.readInt();
        this.frameSize = in.readInt();
        this.numSkins = in.readInt();
        this.numVertices = in.readInt();
        this.numTexcoords = in.readInt();
        this.numTriangles = in.readInt();
        this.numGlCommands = in.readInt();
        this.numFrames = in.readInt();
        this.offsetSkins = in.readInt();
        this.offsetTexcoords = in.readInt();
        this.offsetTriangles = in.readInt();
        this.offsetFrames = in.readInt();
        this.offsetGlCommands = in.readInt();
        this.offsetEnd = in.readInt();
    }

    public int getFacesOffset() {
        return this.offsetTriangles;
    }

    public int getFaceCount() {
        return this.numTriangles;
    }

    public int getTexOffset() {
        return this.offsetTexcoords;
    }

    public int getVertCount() {
        return this.numVertices;
    }

    public int getTexCount() {
        return this.numTexcoords;
    }

    public int getFrameOffset() {
        return this.offsetFrames;
    }

    public int getFrameCount() {
        return this.numFrames;
    }

    public int getTextureHeight() {
        return this.skinHeight;
    }

    public int getTextureWidth() {
        return this.skinWidth;
    }
}

