/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.render.models.md2;

import org.newdawn.render.models.md2.MD2InterpolatedModel;
import org.newdawn.render.models.md2.MD2Model;

public class MD2Anim {
    public static final MD2Anim STAND = new MD2Anim(0, 39, 9, true);
    public static final MD2Anim RUN = new MD2Anim(40, 45, 10, true);
    public static final MD2Anim ATTACK = new MD2Anim(46, 53, 9, true);
    public static final MD2Anim PAIN1 = new MD2Anim(54, 57, 9, true);
    public static final MD2Anim PAIN2 = new MD2Anim(58, 61, 9, true);
    public static final MD2Anim PAIN3 = new MD2Anim(62, 65, 9, true);
    public static final MD2Anim JUMP = new MD2Anim(66, 71, 9, false);
    public static final MD2Anim FLIPOFF = new MD2Anim(72, 83, 9, false);
    public static final MD2Anim SALUTE = new MD2Anim(84, 94, 9, false);
    public static final MD2Anim TAUNT = new MD2Anim(95, 111, 9, false);
    public static final MD2Anim WAVE = new MD2Anim(112, 122, 9, false);
    public static final MD2Anim POINT = new MD2Anim(123, 134, 9, false);
    public static final MD2Anim CRSTAND = new MD2Anim(135, 153, 9, true);
    public static final MD2Anim CRRUN = new MD2Anim(154, 159, 10, true);
    public static final MD2Anim CRATTACK = new MD2Anim(160, 168, 10, true);
    public static final MD2Anim CRPAIN = new MD2Anim(169, 172, 10, true);
    public static final MD2Anim CRDEATH = new MD2Anim(173, 177, 10, false);
    public static final MD2Anim DEATH1 = new MD2Anim(178, 183, 10, false);
    public static final MD2Anim DEATH2 = new MD2Anim(184, 189, 10, false);
    public static final MD2Anim DEATH3 = new MD2Anim(190, 197, 10, false);
    private boolean clone = false;
    private int start;
    private int end;
    private int fps;
    private int countDown;
    private int frame;
    private boolean loop;

    public MD2Anim(int start, int end, int fps, boolean loop) {
        this.start = start;
        this.end = end;
        this.fps = fps;
        this.loop = loop;
        this.frame = start;
        this.countDown = 1000 / fps;
    }

    public boolean contains(int index) {
        return index >= this.start && index <= this.end;
    }

    public int getNextFrame(int current) {
        if (current == this.end) {
            return this.start;
        }
        return current + 1;
    }

    public int getFrame() {
        return this.frame;
    }

    public void update(int delta) {
        if (!this.clone) {
            throw new RuntimeException("Do not use the raw anims, clone them");
        }
        this.countDown -= delta;
        if (this.countDown < 0) {
            ++this.frame;
            if (this.frame > this.end) {
                this.frame = this.loop ? this.start : this.end;
            }
            this.countDown = 1000 / this.fps;
        }
    }

    public void render(MD2Model model) {
        if (!this.clone) {
            throw new RuntimeException("Do not use the raw anims, clone them");
        }
        model.renderFrame(this.frame);
    }

    public void render(MD2InterpolatedModel model) {
        if (!this.clone) {
            throw new RuntimeException("Do not use the raw anims, clone them");
        }
        float delta = 1.0f - (float)this.countDown / (1000.0f / (float)this.fps);
        if (delta >= 1.0f) {
            delta = 0.99f;
        }
        if (!this.loop && this.frame == this.end) {
            delta = 0.0f;
        }
        model.renderFrame(this.frame, delta);
    }

    public MD2Anim copy() {
        MD2Anim copy = new MD2Anim(this.start, this.end, this.fps, this.loop);
        copy.clone = true;
        return copy;
    }
}

