/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.render.buffer.list;

import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.buffer.IndexedTriangleBuffer;
import org.newdawn.render.util.Tuple2;
import org.newdawn.render.util.Tuple3;

public class ListIndexedTriangleBuffer
implements IndexedTriangleBuffer {
    private ArrayList verts = new ArrayList();
    private ArrayList norms = new ArrayList();
    private ArrayList texs = new ArrayList();
    private ArrayList store = new ArrayList();
    private int[] lists;
    private int currentList;

    public int startSet() {
        if (this.lists != null) {
            throw new RuntimeException("Attempt to start set after buffer commit()");
        }
        this.currentList = GL11.glGenLists((int)1);
        GL11.glNewList((int)this.currentList, (int)4864);
        GL11.glBegin((int)4);
        this.store.add(new Integer(this.currentList));
        return this.store.size() - 1;
    }

    public void addPoint(Tuple3 vertex, Tuple3 normal, Tuple2 tex) {
        if (this.lists != null) {
            throw new RuntimeException("Attempt to add point after commit");
        }
        this.verts.add(vertex);
        this.norms.add(normal);
        this.texs.add(tex);
    }

    public void addPointIndex(int index) {
        if (this.lists != null) {
            throw new RuntimeException("Attempt to add point index after commit");
        }
        if (index >= this.verts.size()) {
            throw new RuntimeException("Attempt to use undefined vertx index: " + index);
        }
        Tuple3 normal = (Tuple3)this.norms.get(index);
        Tuple3 vertex = (Tuple3)this.verts.get(index);
        Tuple2 tex = (Tuple2)this.texs.get(index);
        GL11.glNormal3f((float)normal.x, (float)normal.y, (float)normal.z);
        GL11.glTexCoord2f((float)tex.x, (float)tex.y);
        GL11.glVertex3f((float)vertex.x, (float)vertex.y, (float)vertex.z);
    }

    public void endSet() {
        if (this.lists != null) {
            throw new RuntimeException("Attempt to add point index after commit");
        }
        GL11.glEnd();
        GL11.glEndList();
    }

    public void render(int id) {
        if (this.lists == null) {
            throw new RuntimeException("Attempt to render buffer before commit()");
        }
        GL11.glCallList((int)this.lists[id]);
    }

    public void commit() {
        if (this.lists != null) {
            throw new RuntimeException("commit() should only be called once");
        }
        this.lists = new int[this.store.size()];
        for (int i = 0; i < this.store.size(); ++i) {
            Integer id = (Integer)this.store.get(i);
            this.lists[i] = id;
        }
        this.store.clear();
        this.store = null;
        this.norms.clear();
        this.norms = null;
        this.verts.clear();
        this.verts = null;
        this.texs.clear();
        this.texs = null;
    }

    public void release() {
        for (int i = 0; i < this.lists.length; ++i) {
            GL11.glDeleteLists((int)this.lists[i], (int)1);
        }
    }
}

