/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.render.buffer.array;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.buffer.TriangleBuffer;
import org.newdawn.render.util.Tuple2;
import org.newdawn.render.util.Tuple3;

public class VATriangleBuffer
implements TriangleBuffer {
    private ArrayList verts = new ArrayList();
    private ArrayList norms = new ArrayList();
    private ArrayList texs = new ArrayList();
    private ArrayList vertBuffers = new ArrayList();
    private ArrayList normBuffers = new ArrayList();
    private ArrayList texBuffers = new ArrayList();
    private ArrayList counts = new ArrayList();
    private FloatBuffer[] vertices;
    private FloatBuffer[] normals;
    private FloatBuffer[] textures;
    private int currentID;
    private int[] vertCount;
    private boolean normalsEnabled = true;

    public int startSet() {
        this.verts.clear();
        this.norms.clear();
        this.texs.clear();
        this.currentID = this.vertBuffers.size();
        return this.currentID;
    }

    public void addPoint(Tuple3 vertex, Tuple3 normal, Tuple2 tex) {
        this.verts.add(vertex);
        this.norms.add(normal);
        this.texs.add(tex);
    }

    public void endSet() {
        FloatBuffer vertices = BufferUtils.createFloatBuffer((int)(this.verts.size() * 3));
        FloatBuffer normals = BufferUtils.createFloatBuffer((int)(this.verts.size() * 3));
        FloatBuffer textures = BufferUtils.createFloatBuffer((int)(this.verts.size() * 2));
        this.counts.add(new Integer(this.verts.size()));
        for (int i = 0; i < this.verts.size(); ++i) {
            Tuple3 v = (Tuple3)this.verts.get(i);
            vertices.put(v.x).put(v.y).put(v.z);
            Tuple3 n = (Tuple3)this.norms.get(i);
            normals.put(n.x).put(n.y).put(n.z);
            Tuple2 t = (Tuple2)this.texs.get(i);
            textures.put(t.x).put(t.y);
        }
        vertices.flip();
        normals.flip();
        textures.flip();
        this.vertBuffers.add(vertices);
        this.normBuffers.add(normals);
        this.texBuffers.add(textures);
    }

    public void render(int id) {
        GL11.glVertexPointer((int)3, (int)0, (FloatBuffer)this.vertices[id]);
        GL11.glNormalPointer((int)0, (FloatBuffer)this.normals[id]);
        GL11.glTexCoordPointer((int)2, (int)0, (FloatBuffer)this.textures[id]);
        GL11.glDrawArrays((int)4, (int)0, (int)this.vertCount[id]);
    }

    public void commit() {
        GL11.glEnableClientState((int)32884);
        GL11.glEnableClientState((int)32888);
        GL11.glEnableClientState((int)32885);
        int bufferCount = this.vertBuffers.size();
        this.vertices = new FloatBuffer[bufferCount];
        this.normals = new FloatBuffer[bufferCount];
        this.textures = new FloatBuffer[bufferCount];
        this.vertCount = new int[bufferCount];
        for (int i = 0; i < bufferCount; ++i) {
            this.vertices[i] = (FloatBuffer)this.vertBuffers.get(i);
            this.normals[i] = (FloatBuffer)this.normBuffers.get(i);
            this.textures[i] = (FloatBuffer)this.texBuffers.get(i);
            this.vertCount[i] = (Integer)this.counts.get(i);
        }
        this.vertBuffers.clear();
        this.texBuffers.clear();
        this.normBuffers.clear();
        this.counts.clear();
        this.texs.clear();
        this.texs = null;
        this.verts = null;
        this.norms = null;
    }

    public void disableNormals() {
    }

    public void release() {
    }
}

