/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.render.buffer.array;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.buffer.IndexedTriangleBuffer;
import org.newdawn.render.util.Tuple2;
import org.newdawn.render.util.Tuple3;

public class VAIndexedTriangleBuffer
implements IndexedTriangleBuffer {
    private ArrayList verts = new ArrayList();
    private ArrayList norms = new ArrayList();
    private ArrayList texs = new ArrayList();
    private ArrayList inds = new ArrayList();
    private ArrayList frames = new ArrayList();
    private FloatBuffer vertices;
    private FloatBuffer normals;
    private FloatBuffer textures;
    private IntBuffer[] indicies;
    private int currentID;
    private int[] vertCount;

    public int startSet() {
        this.currentID = this.frames.size();
        this.inds = new ArrayList();
        return this.currentID;
    }

    public void addPoint(Tuple3 vertex, Tuple3 normal, Tuple2 tex) {
        this.verts.add(vertex);
        this.norms.add(normal);
        this.texs.add(tex);
    }

    public void endSet() {
        IntBuffer buf = BufferUtils.createIntBuffer((int)this.inds.size());
        for (int i = 0; i < this.inds.size(); ++i) {
            buf.put((Integer)this.inds.get(i));
        }
        buf.flip();
        this.frames.add(buf);
    }

    public void render(int id) {
        GL11.glVertexPointer((int)3, (int)0, (FloatBuffer)this.vertices);
        GL11.glNormalPointer((int)0, (FloatBuffer)this.normals);
        GL11.glTexCoordPointer((int)2, (int)0, (FloatBuffer)this.textures);
        GL11.glDrawElements((int)4, (IntBuffer)this.indicies[id]);
    }

    public void commit() {
        int i;
        GL11.glEnableClientState((int)32884);
        GL11.glEnableClientState((int)32888);
        GL11.glEnableClientState((int)32885);
        this.vertices = BufferUtils.createFloatBuffer((int)(this.verts.size() * 3));
        this.normals = BufferUtils.createFloatBuffer((int)(this.verts.size() * 3));
        this.textures = BufferUtils.createFloatBuffer((int)(this.verts.size() * 2));
        for (i = 0; i < this.verts.size(); ++i) {
            Tuple3 v = (Tuple3)this.verts.get(i);
            this.vertices.put(v.x).put(v.y).put(v.z);
            Tuple3 n = (Tuple3)this.norms.get(i);
            this.normals.put(n.x).put(n.y).put(n.z);
            Tuple2 t = (Tuple2)this.texs.get(i);
            this.textures.put(t.x).put(t.y);
        }
        this.vertices.flip();
        this.normals.flip();
        this.textures.flip();
        this.indicies = new IntBuffer[this.frames.size()];
        for (i = 0; i < this.frames.size(); ++i) {
            this.indicies[i] = (IntBuffer)this.frames.get(i);
        }
        this.frames.clear();
        this.verts.clear();
        this.norms.clear();
        this.texs.clear();
        this.inds.clear();
        this.inds = null;
        this.frames = null;
        this.texs = null;
        this.verts = null;
        this.norms = null;
    }

    public void addPointIndex(int index) {
        if (index >= this.verts.size()) {
            throw new RuntimeException("Attempt to use undefined vertex: " + index);
        }
        this.inds.add(new Integer(index));
    }

    public void release() {
    }
}

