/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.render.buffer.array;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBVertexBufferObject;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.buffer.TriangleBuffer;
import org.newdawn.render.util.Tuple2;
import org.newdawn.render.util.Tuple3;

public class ARBTriangleBuffer
implements TriangleBuffer {
    private ArrayList verts = new ArrayList();
    private ArrayList norms = new ArrayList();
    private ArrayList texs = new ArrayList();
    private ArrayList offs = new ArrayList();
    private int[] offsets;
    private int vertVBO;
    private int texVBO;
    private int normVBO;
    private FloatBuffer vertices;
    private FloatBuffer normals;
    private FloatBuffer textures;
    private boolean normalsEnabled = true;

    public int startSet() {
        this.offs.add(new Integer(this.verts.size()));
        return this.offs.size() - 1;
    }

    public void addPoint(Tuple3 vertex, Tuple3 normal, Tuple2 tex) {
        this.verts.add(vertex);
        this.norms.add(normal);
        this.texs.add(tex);
    }

    public void endSet() {
    }

    public void render(int id) {
        GL11.glEnableClientState((int)32884);
        GL11.glEnableClientState((int)32888);
        GL11.glEnableClientState((int)32885);
        ARBVertexBufferObject.glBindBufferARB((int)34962, (int)this.vertVBO);
        GL11.glVertexPointer((int)3, (int)5126, (int)0, (long)0L);
        ARBVertexBufferObject.glBindBufferARB((int)34962, (int)this.texVBO);
        GL11.glTexCoordPointer((int)2, (int)5126, (int)0, (long)0L);
        ARBVertexBufferObject.glBindBufferARB((int)34962, (int)this.normVBO);
        GL11.glNormalPointer((int)5126, (int)0, (long)0L);
        GL11.glDrawArrays((int)4, (int)this.offsets[id], (int)(this.offsets[id + 1] - this.offsets[id]));
    }

    public void commit() {
        int i;
        int total = this.offs.size();
        this.offsets = new int[total + 1];
        for (i = 0; i < total; ++i) {
            this.offsets[i] = (Integer)this.offs.get(i);
        }
        this.offsets[total] = this.verts.size();
        this.vertices = BufferUtils.createFloatBuffer((int)(this.verts.size() * 3));
        this.normals = BufferUtils.createFloatBuffer((int)(this.verts.size() * 3));
        this.textures = BufferUtils.createFloatBuffer((int)(this.verts.size() * 2));
        for (i = 0; i < this.verts.size(); ++i) {
            Tuple3 v = (Tuple3)this.verts.get(i);
            this.vertices.put(v.x).put(v.y).put(v.z);
            Tuple3 n = (Tuple3)this.norms.get(i);
            this.normals.put(n.x).put(n.y).put(n.z);
            Tuple2 t = (Tuple2)this.texs.get(i);
            this.textures.put(t.x).put(t.y);
        }
        this.vertices.flip();
        this.normals.flip();
        this.textures.flip();
        this.vertVBO = this.genVBO();
        ARBVertexBufferObject.glBindBufferARB((int)34962, (int)this.vertVBO);
        ARBVertexBufferObject.glBufferDataARB((int)34962, (FloatBuffer)this.vertices, (int)35044);
        this.texVBO = this.genVBO();
        ARBVertexBufferObject.glBindBufferARB((int)34962, (int)this.texVBO);
        ARBVertexBufferObject.glBufferDataARB((int)34962, (FloatBuffer)this.textures, (int)35044);
        this.normVBO = this.genVBO();
        ARBVertexBufferObject.glBindBufferARB((int)34962, (int)this.normVBO);
        ARBVertexBufferObject.glBufferDataARB((int)34962, (FloatBuffer)this.normals, (int)35044);
        this.normals.clear();
        this.vertices.clear();
        this.textures.clear();
        this.offs.clear();
        this.verts.clear();
        this.norms.clear();
        this.texs.clear();
        this.texs = null;
        this.verts = null;
        this.norms = null;
        this.offs = null;
    }

    private int genVBO() {
        IntBuffer scratch = BufferUtils.createIntBuffer((int)1);
        ARBVertexBufferObject.glGenBuffersARB((IntBuffer)scratch);
        return scratch.get();
    }

    public void disableNormals() {
        this.normalsEnabled = false;
    }

    public void release() {
        IntBuffer buf = BufferUtils.createIntBuffer((int)1);
        buf.put(this.vertVBO);
        buf.flip();
        ARBVertexBufferObject.glDeleteBuffersARB((IntBuffer)buf);
        buf = BufferUtils.createIntBuffer((int)1);
        buf.put(this.texVBO);
        buf.flip();
        ARBVertexBufferObject.glDeleteBuffersARB((IntBuffer)buf);
        buf = BufferUtils.createIntBuffer((int)1);
        buf.put(this.normVBO);
        buf.flip();
        ARBVertexBufferObject.glDeleteBuffersARB((IntBuffer)buf);
    }
}

