/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.render.buffer.array;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBVertexBufferObject;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.buffer.IndexedTriangleBuffer;
import org.newdawn.render.util.Tuple2;
import org.newdawn.render.util.Tuple3;

public class ARBIndexedTriangleBuffer
implements IndexedTriangleBuffer {
    private ArrayList verts = new ArrayList();
    private ArrayList norms = new ArrayList();
    private ArrayList texs = new ArrayList();
    private ArrayList frames = new ArrayList();
    private ArrayList inds;
    private IntBuffer[] indicies;
    private int vertVBO;
    private int texVBO;
    private int normVBO;
    private FloatBuffer vertices;
    private FloatBuffer normals;
    private FloatBuffer textures;

    public int startSet() {
        if (this.inds != null) {
            throw new RuntimeException("Attempting to start a set while one is already started");
        }
        this.inds = new ArrayList();
        return this.frames.size();
    }

    public void addPoint(Tuple3 vertex, Tuple3 normal, Tuple2 tex) {
        this.verts.add(vertex);
        this.norms.add(normal);
        this.texs.add(tex);
    }

    public void endSet() {
        if (this.inds == null) {
            throw new RuntimeException("Attempt to endSet() before starting one");
        }
        IntBuffer buf = BufferUtils.createIntBuffer((int)this.inds.size());
        for (int i = 0; i < this.inds.size(); ++i) {
            buf.put((Integer)this.inds.get(i));
        }
        buf.flip();
        this.frames.add(buf);
        this.inds = null;
    }

    public void render(int id) {
        if (this.frames != null) {
            throw new RuntimeException("Attempt to render before commit()");
        }
        GL11.glEnableClientState((int)32884);
        GL11.glEnableClientState((int)32888);
        GL11.glEnableClientState((int)32885);
        ARBVertexBufferObject.glBindBufferARB((int)34962, (int)this.vertVBO);
        GL11.glVertexPointer((int)3, (int)5126, (int)0, (long)0L);
        ARBVertexBufferObject.glBindBufferARB((int)34962, (int)this.normVBO);
        GL11.glNormalPointer((int)5126, (int)0, (long)0L);
        ARBVertexBufferObject.glBindBufferARB((int)34962, (int)this.texVBO);
        GL11.glTexCoordPointer((int)2, (int)5126, (int)0, (long)0L);
        GL11.glDrawElements((int)4, (IntBuffer)this.indicies[id]);
    }

    public void commit() {
        int i;
        if (this.frames.size() == 0) {
            throw new RuntimeException("commit() attempted with no frames");
        }
        if (this.inds != null) {
            throw new RuntimeException("commit() attempted in mid-set definition, remember to call endSet()");
        }
        this.indicies = new IntBuffer[this.frames.size()];
        for (i = 0; i < this.frames.size(); ++i) {
            this.indicies[i] = (IntBuffer)this.frames.get(i);
        }
        this.vertices = BufferUtils.createFloatBuffer((int)(this.verts.size() * 3));
        this.normals = BufferUtils.createFloatBuffer((int)(this.verts.size() * 3));
        this.textures = BufferUtils.createFloatBuffer((int)(this.verts.size() * 2));
        for (i = 0; i < this.verts.size(); ++i) {
            Tuple3 v = (Tuple3)this.verts.get(i);
            this.vertices.put(v.x).put(v.y).put(v.z);
            Tuple3 n = (Tuple3)this.norms.get(i);
            this.normals.put(n.x).put(n.y).put(n.z);
            Tuple2 t = (Tuple2)this.texs.get(i);
            this.textures.put(t.x).put(t.y);
        }
        this.vertices.flip();
        this.normals.flip();
        this.textures.flip();
        this.vertVBO = this.genVBO();
        ARBVertexBufferObject.glBindBufferARB((int)34962, (int)this.vertVBO);
        ARBVertexBufferObject.glBufferDataARB((int)34962, (FloatBuffer)this.vertices, (int)35044);
        this.texVBO = this.genVBO();
        ARBVertexBufferObject.glBindBufferARB((int)34962, (int)this.texVBO);
        ARBVertexBufferObject.glBufferDataARB((int)34962, (FloatBuffer)this.textures, (int)35044);
        this.normVBO = this.genVBO();
        ARBVertexBufferObject.glBindBufferARB((int)34962, (int)this.normVBO);
        ARBVertexBufferObject.glBufferDataARB((int)34962, (FloatBuffer)this.normals, (int)35044);
        this.normals.clear();
        this.vertices.clear();
        this.textures.clear();
        this.frames.clear();
        this.verts.clear();
        this.norms.clear();
        this.texs.clear();
        this.texs = null;
        this.verts = null;
        this.norms = null;
        this.frames = null;
    }

    private int genVBO() {
        IntBuffer scratch = BufferUtils.createIntBuffer((int)1);
        ARBVertexBufferObject.glGenBuffersARB((IntBuffer)scratch);
        return scratch.get();
    }

    public void addPointIndex(int index) {
        if (index >= this.verts.size()) {
            throw new RuntimeException("Attempt to use undefined vertex: " + index);
        }
        this.inds.add(new Integer(index));
    }

    public void release() {
        IntBuffer buf = BufferUtils.createIntBuffer((int)1);
        buf.put(this.vertVBO);
        buf.flip();
        ARBVertexBufferObject.glDeleteBuffersARB((IntBuffer)buf);
        buf = BufferUtils.createIntBuffer((int)1);
        buf.put(this.texVBO);
        buf.flip();
        ARBVertexBufferObject.glDeleteBuffersARB((IntBuffer)buf);
        buf = BufferUtils.createIntBuffer((int)1);
        buf.put(this.normVBO);
        buf.flip();
        ARBVertexBufferObject.glDeleteBuffersARB((IntBuffer)buf);
    }
}

