/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.render.buffer;

import org.newdawn.render.buffer.IndexedTriangleBuffer;
import org.newdawn.render.buffer.TriangleBuffer;
import org.newdawn.render.buffer.array.ARBIndexedTriangleBuffer;
import org.newdawn.render.buffer.array.ARBTriangleBuffer;
import org.newdawn.render.buffer.array.VAIndexedTriangleBuffer;
import org.newdawn.render.buffer.list.ListTriangleBuffer;
import org.newdawn.util.Log;

public final class BufferFactory {
    private static boolean vboSupported = false;
    private static boolean arbSupported = false;
    private static boolean inited = false;

    private static void init() {
        if (!inited) {
            inited = true;
            vboSupported = false;
            arbSupported = false;
            Log.log((String)("Using ARB Vertex Buffer Objects: " + arbSupported));
        }
    }

    private BufferFactory() {
    }

    public static TriangleBuffer createTriangleBuffer() {
        BufferFactory.init();
        if (arbSupported) {
            return new ARBTriangleBuffer();
        }
        return new ListTriangleBuffer();
    }

    public static IndexedTriangleBuffer createIndexedTriangleBuffer() {
        BufferFactory.init();
        if (arbSupported) {
            return new ARBIndexedTriangleBuffer();
        }
        return new VAIndexedTriangleBuffer();
    }
}

