/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.WindowsDirectInput;
import org.lwjgl.opengl.WindowsDirectInputDevice;

final class WindowsKeyboard {
    private static final int BUFFER_SIZE = 50;
    private final WindowsDirectInput dinput;
    private final WindowsDirectInputDevice keyboard;
    private final IntBuffer temp_data_buffer;
    private final ByteBuffer keyboard_state;
    private final CharBuffer unicode_buffer;

    public WindowsKeyboard(WindowsDirectInput dinput, long hwnd) throws LWJGLException {
        this.dinput = dinput;
        try {
            this.keyboard = dinput.createDevice(1);
            try {
                this.keyboard.setCooperateLevel(hwnd, 6);
                this.keyboard.setDataFormat(1);
                this.keyboard.setBufferSize(50);
            }
            catch (LWJGLException e) {
                this.keyboard.release();
                throw e;
            }
        }
        catch (LWJGLException e) {
            dinput.release();
            throw e;
        }
        this.keyboard.acquire();
        this.temp_data_buffer = BufferUtils.createIntBuffer(150);
        this.keyboard_state = BufferUtils.createByteBuffer(256);
        this.unicode_buffer = BufferUtils.createCharBuffer(50);
    }

    public void destroy() {
        this.keyboard.unacquire();
        this.keyboard.release();
        this.dinput.release();
    }

    public void poll(ByteBuffer keyDownBuffer) {
        int ret = this.keyboard.acquire();
        if (ret != 0 && ret != 1) {
            return;
        }
        this.keyboard.poll();
        ret = this.keyboard.getDeviceState(keyDownBuffer);
        switch (ret) {
            case 0: {
                break;
            }
            case 1: {
                LWJGLUtil.log("Keyboard buffer overflow");
                break;
            }
            case -2147024866: {
                break;
            }
            case -2147024868: {
                break;
            }
            default: {
                LWJGLUtil.log("Failed to poll keyboard (0x" + Integer.toHexString(ret) + ")");
            }
        }
    }

    private void translateData(IntBuffer src, ByteBuffer dst) {
        while (dst.hasRemaining() && src.hasRemaining()) {
            int dwOfs = src.get();
            dst.putInt(dwOfs);
            byte dwData = (byte)src.get();
            boolean key_down = (dwData & 0x80) != 0;
            dst.put(key_down ? (byte)1 : 0);
            long dwTimeStamp = (long)src.get() & 0xFFFFFFFFFFFFFFFFL;
            long nanos = dwTimeStamp * 1000000L;
            if (key_down) {
                int virt_key = WindowsKeyboard.MapVirtualKey(dwOfs, 1);
                if (virt_key != 0 && WindowsKeyboard.GetKeyboardState(this.keyboard_state) != 0) {
                    this.unicode_buffer.clear();
                    int num_chars = WindowsKeyboard.ToUnicode(virt_key, dwOfs &= Short.MAX_VALUE, this.keyboard_state, this.unicode_buffer, this.unicode_buffer.capacity(), 0);
                    if (num_chars > 0) {
                        int current_char = 0;
                        do {
                            if (current_char >= 1) {
                                dst.putInt(0);
                                dst.put((byte)0);
                            }
                            int char_int = this.unicode_buffer.get() & 0xFFFF;
                            dst.putInt(char_int);
                            dst.putLong(nanos);
                        } while (dst.hasRemaining() && ++current_char < num_chars);
                        continue;
                    }
                    dst.putInt(0);
                    dst.putLong(nanos);
                    continue;
                }
                dst.putInt(0);
                dst.putLong(nanos);
                continue;
            }
            dst.putInt(0);
            dst.putLong(nanos);
        }
    }

    private static native int MapVirtualKey(int var0, int var1);

    private static native int ToUnicode(int var0, int var1, ByteBuffer var2, CharBuffer var3, int var4, int var5);

    private static native int GetKeyboardState(ByteBuffer var0);

    public void read(ByteBuffer buffer) {
        int ret = this.keyboard.acquire();
        if (ret != 0 && ret != 1) {
            return;
        }
        this.keyboard.poll();
        this.temp_data_buffer.clear();
        ret = this.keyboard.getDeviceData(this.temp_data_buffer);
        switch (ret) {
            case 0: {
                break;
            }
            case 1: {
                LWJGLUtil.log("Keyboard buffer overflow");
                break;
            }
            case -2147024866: {
                break;
            }
            case -2147024868: {
                break;
            }
            default: {
                LWJGLUtil.log("Failed to read keyboard (0x" + Integer.toHexString(ret) + ")");
            }
        }
        this.temp_data_buffer.flip();
        this.translateData(this.temp_data_buffer, buffer);
    }
}

