/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayImplementation;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.PeerInfo;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.WindowsDirectInput;
import org.lwjgl.opengl.WindowsDirectInput3;
import org.lwjgl.opengl.WindowsDirectInput8;
import org.lwjgl.opengl.WindowsDisplayPeerInfo;
import org.lwjgl.opengl.WindowsFileVersion;
import org.lwjgl.opengl.WindowsKeyboard;
import org.lwjgl.opengl.WindowsMouse;
import org.lwjgl.opengl.WindowsPbufferPeerInfo;
import org.lwjgl.opengl.WindowsRegistry;

final class WindowsDisplay
implements DisplayImplementation {
    private static final int GAMMA_LENGTH = 256;
    private static final int WM_MOUSEMOVE = 512;
    private static final int WM_LBUTTONDOWN = 513;
    private static final int WM_LBUTTONUP = 514;
    private static final int WM_LBUTTONDBLCLK = 515;
    private static final int WM_RBUTTONDOWN = 516;
    private static final int WM_RBUTTONUP = 517;
    private static final int WM_RBUTTONDBLCLK = 518;
    private static final int WM_MBUTTONDOWN = 519;
    private static final int WM_MBUTTONUP = 520;
    private static final int WM_MBUTTONDBLCLK = 521;
    private static final int WM_MOUSEWHEEL = 522;
    private static final int WM_QUIT = 18;
    private static final int WM_SYSCOMMAND = 274;
    private static final int WM_PAINT = 15;
    private static final int SC_SIZE = 61440;
    private static final int SC_MOVE = 61456;
    private static final int SC_MINIMIZE = 61472;
    private static final int SC_MAXIMIZE = 61488;
    private static final int SC_NEXTWINDOW = 61504;
    private static final int SC_PREVWINDOW = 61520;
    private static final int SC_CLOSE = 61536;
    private static final int SC_VSCROLL = 61552;
    private static final int SC_HSCROLL = 61568;
    private static final int SC_MOUSEMENU = 61584;
    private static final int SC_KEYMENU = 61696;
    private static final int SC_ARRANGE = 61712;
    private static final int SC_RESTORE = 61728;
    private static final int SC_TASKLIST = 61744;
    private static final int SC_SCREENSAVE = 61760;
    private static final int SC_HOTKEY = 61776;
    private static final int SC_DEFAULT = 61792;
    private static final int SC_MONITORPOWER = 61808;
    private static final int SC_CONTEXTHELP = 61824;
    private static final int SC_SEPARATOR = 61455;
    private static final int SM_CXCURSOR = 13;
    private static final int SIZE_RESTORED = 0;
    private static final int SIZE_MINIMIZED = 1;
    private static final int SIZE_MAXIMIZED = 2;
    private static final int WM_SIZE = 5;
    private static final int WM_ACTIVATE = 6;
    private static final int WA_INACTIVE = 0;
    private static final int WA_ACTIVE = 1;
    private static final int WA_CLICKACTIVE = 2;
    private static final int SW_SHOWMINNOACTIVE = 7;
    private static final int SW_RESTORE = 9;
    private static WindowsDisplay current_display;
    private WindowsDisplayPeerInfo peer_info;
    private WindowsKeyboard keyboard;
    private WindowsMouse mouse;
    private boolean close_requested;
    private boolean is_dirty;
    private ByteBuffer current_gamma;
    private ByteBuffer saved_gamma;
    private DisplayMode current_mode;
    private boolean mode_set;
    private boolean isFullscreen;
    private boolean isMinimized;
    private boolean isFocused;
    private boolean did_maximize;
    private boolean inAppActivate;

    public WindowsDisplay() {
        current_display = this;
    }

    public void createWindow(DisplayMode mode, boolean fullscreen, int x, int y) throws LWJGLException {
        this.close_requested = false;
        this.is_dirty = false;
        this.isFullscreen = fullscreen;
        this.isMinimized = false;
        this.isFocused = false;
        this.did_maximize = false;
        this.nCreateWindow(mode, fullscreen, x, y);
        this.peer_info.initDC();
    }

    private native void nCreateWindow(DisplayMode var1, boolean var2, int var3, int var4) throws LWJGLException;

    public void destroyWindow() {
        WindowsDisplay.nDestroyWindow();
        if (this.isFullscreen) {
            WindowsDisplay.resetCursorClipping();
        }
    }

    private static native void nDestroyWindow();

    private static native void resetCursorClipping();

    private static native void setupCursorClipping(long var0) throws LWJGLException;

    public void switchDisplayMode(DisplayMode mode) throws LWJGLException {
        WindowsDisplay.nSwitchDisplayMode(mode);
        this.current_mode = mode;
        this.mode_set = true;
    }

    private static native void nSwitchDisplayMode(DisplayMode var0) throws LWJGLException;

    private void appActivate(boolean active) {
        if (this.inAppActivate) {
            return;
        }
        this.inAppActivate = true;
        this.isFocused = active;
        if (active) {
            if (this.isFullscreen) {
                this.restoreDisplayMode();
            }
            WindowsDisplay.showWindow(WindowsDisplay.getHwnd(), 9);
            WindowsDisplay.setForegroundWindow(WindowsDisplay.getHwnd());
            WindowsDisplay.setFocus(WindowsDisplay.getHwnd());
            this.did_maximize = true;
        } else if (this.isFullscreen) {
            WindowsDisplay.showWindow(WindowsDisplay.getHwnd(), 7);
            this.resetDisplayMode();
        }
        this.inAppActivate = false;
    }

    private static native void showWindow(long var0, int var2);

    private static native void setForegroundWindow(long var0);

    private static native void setFocus(long var0);

    private void restoreDisplayMode() {
        try {
            this.doSetGammaRamp(this.current_gamma);
        }
        catch (LWJGLException e) {
            LWJGLUtil.log("Failed to restore gamma: " + e.getMessage());
        }
        if (!this.mode_set) {
            this.mode_set = true;
            try {
                WindowsDisplay.nSwitchDisplayMode(this.current_mode);
            }
            catch (LWJGLException e) {
                LWJGLUtil.log("Failed to restore display mode: " + e.getMessage());
            }
        }
    }

    public void resetDisplayMode() {
        try {
            this.doSetGammaRamp(this.saved_gamma);
        }
        catch (LWJGLException e) {
            LWJGLUtil.log("Failed to reset gamma ramp: " + e.getMessage());
        }
        this.current_gamma = this.saved_gamma;
        if (this.mode_set) {
            this.mode_set = false;
            WindowsDisplay.nResetDisplayMode();
        }
        WindowsDisplay.resetCursorClipping();
    }

    private static native void nResetDisplayMode();

    public int getGammaRampLength() {
        return 256;
    }

    public void setGammaRamp(FloatBuffer gammaRamp) throws LWJGLException {
        this.doSetGammaRamp(WindowsDisplay.convertToNativeRamp(gammaRamp));
    }

    private static native ByteBuffer convertToNativeRamp(FloatBuffer var0) throws LWJGLException;

    private static native ByteBuffer getCurrentGammaRamp() throws LWJGLException;

    private void doSetGammaRamp(ByteBuffer native_gamma) throws LWJGLException {
        WindowsDisplay.nSetGammaRamp(native_gamma);
        this.current_gamma = native_gamma;
    }

    private static native void nSetGammaRamp(ByteBuffer var0) throws LWJGLException;

    public String getAdapter() {
        try {
            String adapter_string = WindowsRegistry.queryRegistrationKey(3, "HARDWARE\\DeviceMap\\Video", "\\Device\\Video0");
            String root_key = "\\registry\\machine\\";
            if (adapter_string.toLowerCase().startsWith(root_key)) {
                String driver_value = WindowsRegistry.queryRegistrationKey(3, adapter_string.substring(root_key.length()), "InstalledDisplayDrivers");
                return driver_value;
            }
        }
        catch (LWJGLException e) {
            LWJGLUtil.log("Exception occurred while querying registry: " + e);
        }
        return null;
    }

    public String getVersion() {
        String driver = this.getAdapter();
        if (driver != null) {
            WindowsFileVersion version = this.nGetVersion(driver + ".dll");
            return version.toString();
        }
        return null;
    }

    private native WindowsFileVersion nGetVersion(String var1);

    public DisplayMode init() throws LWJGLException {
        this.current_gamma = this.saved_gamma = WindowsDisplay.getCurrentGammaRamp();
        this.current_mode = WindowsDisplay.getCurrentDisplayMode();
        return this.current_mode;
    }

    private static native DisplayMode getCurrentDisplayMode() throws LWJGLException;

    public native void setTitle(String var1);

    public boolean isCloseRequested() {
        boolean saved = this.close_requested;
        this.close_requested = false;
        return saved;
    }

    public boolean isVisible() {
        return !this.isMinimized;
    }

    public boolean isActive() {
        return this.isFocused;
    }

    public boolean isDirty() {
        boolean saved = this.is_dirty;
        this.is_dirty = false;
        return saved;
    }

    public PeerInfo createPeerInfo(PixelFormat pixel_format) throws LWJGLException {
        this.peer_info = new WindowsDisplayPeerInfo(pixel_format);
        return this.peer_info;
    }

    public void update() {
        WindowsDisplay.nUpdate();
        if (this.did_maximize) {
            this.did_maximize = false;
            try {
                if (Display.getContext().isCurrent()) {
                    Display.getContext().makeCurrent();
                }
            }
            catch (LWJGLException e) {
                LWJGLUtil.log("Exception occurred while trying to make context current: " + e);
            }
        }
    }

    private static native void nUpdate();

    public void reshape(int x, int y, int width, int height) {
        if (!this.isFullscreen) {
            WindowsDisplay.nReshape(WindowsDisplay.getHwnd(), x, y, width, height);
        }
    }

    private static native void nReshape(long var0, int var2, int var3, int var4, int var5);

    public native DisplayMode[] getAvailableDisplayModes() throws LWJGLException;

    public boolean hasWheel() {
        return this.mouse.hasWheel();
    }

    public int getButtonCount() {
        return this.mouse.getButtonCount();
    }

    public void createMouse() throws LWJGLException {
        this.mouse = new WindowsMouse(WindowsDisplay.createDirectInput(), WindowsDisplay.getHwnd());
    }

    public void destroyMouse() {
        this.mouse.destroy();
        this.mouse = null;
    }

    public void pollMouse(IntBuffer coord_buffer, ByteBuffer buttons) {
        this.update();
        this.mouse.poll(coord_buffer, buttons);
    }

    public void readMouse(ByteBuffer buffer) {
        this.update();
        this.mouse.read(buffer);
    }

    public void grabMouse(boolean grab) {
        this.mouse.grab(grab);
    }

    public int getNativeCursorCapabilities() {
        return 1;
    }

    public void setCursorPosition(int x, int y) {
        WindowsDisplay.nSetCursorPosition(x, y, this.isFullscreen);
    }

    private static native void nSetCursorPosition(int var0, int var1, boolean var2);

    public native void setNativeCursor(Object var1) throws LWJGLException;

    public int getMinCursorSize() {
        return this.getSystemMetrics(13);
    }

    public int getMaxCursorSize() {
        return this.getSystemMetrics(13);
    }

    public native int getSystemMetrics(int var1);

    private static native long getDllInstance();

    private static native long getHwnd();

    public void createKeyboard() throws LWJGLException {
        this.keyboard = new WindowsKeyboard(WindowsDisplay.createDirectInput(), WindowsDisplay.getHwnd());
    }

    public void destroyKeyboard() {
        this.keyboard.destroy();
        this.keyboard = null;
    }

    public void pollKeyboard(ByteBuffer keyDownBuffer) {
        this.update();
        this.keyboard.poll(keyDownBuffer);
    }

    public void readKeyboard(ByteBuffer buffer) {
        this.update();
        this.keyboard.read(buffer);
    }

    public native ByteBuffer nCreateCursor(int var1, int var2, int var3, int var4, int var5, IntBuffer var6, int var7, IntBuffer var8, int var9) throws LWJGLException;

    public Object createCursor(int width, int height, int xHotspot, int yHotspot, int numImages, IntBuffer images, IntBuffer delays) throws LWJGLException {
        return this.nCreateCursor(width, height, xHotspot, yHotspot, numImages, images, images.position(), delays, delays != null ? delays.position() : -1);
    }

    public native void destroyCursor(Object var1);

    public int getPbufferCapabilities() {
        try {
            return this.nGetPbufferCapabilities(new PixelFormat(0, 0, 0, 0, 0, 0, 0, 0, false));
        }
        catch (LWJGLException e) {
            LWJGLUtil.log("Exception occurred while determining pbuffer capabilities: " + e);
            return 0;
        }
    }

    private native int nGetPbufferCapabilities(PixelFormat var1) throws LWJGLException;

    public boolean isBufferLost(PeerInfo handle) {
        return ((WindowsPbufferPeerInfo)handle).isBufferLost();
    }

    public PeerInfo createPbuffer(int width, int height, PixelFormat pixel_format, IntBuffer pixelFormatCaps, IntBuffer pBufferAttribs) throws LWJGLException {
        return new WindowsPbufferPeerInfo(width, height, pixel_format, pixelFormatCaps, pBufferAttribs);
    }

    public void setPbufferAttrib(PeerInfo handle, int attrib, int value) {
        ((WindowsPbufferPeerInfo)handle).setPbufferAttrib(attrib, value);
    }

    public void bindTexImageToPbuffer(PeerInfo handle, int buffer) {
        ((WindowsPbufferPeerInfo)handle).bindTexImageToPbuffer(buffer);
    }

    public void releaseTexImageFromPbuffer(PeerInfo handle, int buffer) {
        ((WindowsPbufferPeerInfo)handle).releaseTexImageFromPbuffer(buffer);
    }

    public int setIcon(ByteBuffer[] icons) {
        boolean done16 = false;
        boolean done32 = false;
        int used = 0;
        for (int i = 0; i < icons.length; ++i) {
            int size = icons[i].limit() / 4;
            if ((int)Math.sqrt(size) == 16 && !done16) {
                WindowsDisplay.nSetWindowIcon16(icons[i].asIntBuffer());
                ++used;
                done16 = true;
            }
            if ((int)Math.sqrt(size) != 32 || done32) continue;
            WindowsDisplay.nSetWindowIcon32(icons[i].asIntBuffer());
            ++used;
            done32 = true;
        }
        return used;
    }

    private static native int nSetWindowIcon16(IntBuffer var0);

    private static native int nSetWindowIcon32(IntBuffer var0);

    private void handleMouseButton(int button, int state, long millis) {
        if (this.mouse != null) {
            this.mouse.handleMouseButton((byte)button, (byte)state, millis);
        }
    }

    private void handleMouseMoved(int x, int y, long millis) {
        if (this.mouse != null) {
            this.mouse.handleMouseMoved(x, y, millis);
        }
    }

    private void handleMouseScrolled(int amount, long millis) {
        if (this.mouse != null) {
            this.mouse.handleMouseScrolled(amount, millis);
        }
    }

    private static native int transformY(long var0, int var2);

    private static boolean handleMessage(long hwnd, int msg, long wParam, long lParam, long millis) {
        if (current_display != null) {
            return current_display.doHandleMessage(hwnd, msg, wParam, lParam, millis);
        }
        return false;
    }

    private boolean doHandleMessage(long hwnd, int msg, long wParam, long lParam, long millis) {
        if (this.isFullscreen && !this.isMinimized && this.isFocused) {
            try {
                WindowsDisplay.setupCursorClipping(WindowsDisplay.getHwnd());
            }
            catch (LWJGLException e) {
                LWJGLUtil.log("setupCursorClipping failed: " + e.getMessage());
            }
        }
        switch (msg) {
            case 6: {
                switch ((int)wParam) {
                    case 1: 
                    case 2: {
                        this.appActivate(true);
                        break;
                    }
                    case 0: {
                        this.appActivate(false);
                    }
                }
                return true;
            }
            case 5: {
                switch ((int)wParam) {
                    case 0: 
                    case 2: {
                        this.isMinimized = false;
                        break;
                    }
                    case 1: {
                        this.isMinimized = true;
                    }
                }
                return false;
            }
            case 512: {
                short xPos = (short)(lParam & 0xFFFFL);
                int yPos = WindowsDisplay.transformY(WindowsDisplay.getHwnd(), (short)(lParam >> 16 & 0xFFFFL));
                this.handleMouseMoved(xPos, yPos, millis);
                return true;
            }
            case 522: {
                short dwheel = (short)(wParam >> 16 & 0xFFFFL);
                this.handleMouseScrolled(dwheel, millis);
                return true;
            }
            case 513: {
                this.handleMouseButton(0, 1, millis);
                return true;
            }
            case 514: {
                this.handleMouseButton(0, 0, millis);
                return true;
            }
            case 516: {
                this.handleMouseButton(1, 1, millis);
                return true;
            }
            case 517: {
                this.handleMouseButton(1, 0, millis);
                return true;
            }
            case 519: {
                this.handleMouseButton(2, 1, millis);
                return true;
            }
            case 520: {
                this.handleMouseButton(2, 0, millis);
                return true;
            }
            case 18: {
                this.close_requested = true;
                return true;
            }
            case 274: {
                switch ((int)wParam) {
                    case 61584: 
                    case 61696: 
                    case 61760: 
                    case 61808: {
                        return true;
                    }
                    case 61536: {
                        this.close_requested = true;
                        return true;
                    }
                }
                return false;
            }
            case 15: {
                this.is_dirty = true;
                return false;
            }
        }
        return false;
    }

    private static WindowsDirectInput createDirectInput() throws LWJGLException {
        try {
            return new WindowsDirectInput8(WindowsDisplay.getDllInstance());
        }
        catch (LWJGLException e) {
            LWJGLUtil.log("Failed to create DirectInput 8 interface, falling back to DirectInput 3");
            return new WindowsDirectInput3(WindowsDisplay.getDllInstance());
        }
    }
}

