/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayImplementation;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.LinuxDisplayPeerInfo;
import org.lwjgl.opengl.LinuxKeyboard;
import org.lwjgl.opengl.LinuxMouse;
import org.lwjgl.opengl.LinuxPbufferPeerInfo;
import org.lwjgl.opengl.PeerInfo;
import org.lwjgl.opengl.PixelFormat;

final class LinuxDisplay
implements DisplayImplementation {
    private static final int GrabSuccess = 0;
    private static final int AutoRepeatModeOff = 0;
    private static final int AutoRepeatModeOn = 1;
    private static final int AutoRepeatModeDefault = 2;
    private static final int FULLSCREEN_LEGACY = 1;
    private static final int FULLSCREEN_NETWM = 2;
    private static final int WINDOWED = 3;
    private static int current_window_mode = 3;
    private static final int XRANDR = 10;
    private static final int XF86VIDMODE = 11;
    private static final int NONE = 12;
    private static Thread current_awt_lock_owner;
    private static int awt_lock_count;
    private static int display_connection_usage_count;
    private int current_displaymode_extension = 12;
    private PeerInfo peer_info;
    private ByteBuffer saved_gamma;
    private ByteBuffer current_gamma;
    private DisplayMode saved_mode;
    private DisplayMode current_mode;
    private boolean keyboard_grabbed;
    private boolean pointer_grabbed;
    private boolean input_released;
    private boolean grab;
    private boolean focused;
    private boolean minimized;
    private boolean dirty;
    private boolean close_requested;
    private ByteBuffer current_cursor;
    private ByteBuffer blank_cursor;
    private LinuxKeyboard keyboard;
    private LinuxMouse mouse;

    LinuxDisplay() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer getCurrentGammaRamp() throws LWJGLException {
        LinuxDisplay.lockAWT();
        try {
            block8: {
                ByteBuffer byteBuffer;
                LinuxDisplay.incDisplay();
                try {
                    if (!LinuxDisplay.isXF86VidModeSupported()) break block8;
                    byteBuffer = LinuxDisplay.nGetCurrentGammaRamp();
                }
                catch (Throwable throwable) {
                    LinuxDisplay.decDisplay();
                    throw throwable;
                }
                LinuxDisplay.decDisplay();
                return byteBuffer;
            }
            ByteBuffer byteBuffer = null;
            LinuxDisplay.decDisplay();
            return byteBuffer;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native ByteBuffer nGetCurrentGammaRamp() throws LWJGLException;

    private static int getBestDisplayModeExtension() {
        int result;
        if (LinuxDisplay.isXrandrSupported()) {
            LWJGLUtil.log("Using Xrandr for display mode switching");
            result = 10;
        } else if (LinuxDisplay.isXF86VidModeSupported()) {
            LWJGLUtil.log("Using XF86VidMode for display mode switching");
            result = 11;
        } else {
            LWJGLUtil.log("No display mode extensions available");
            result = 12;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isXrandrSupported() {
        if (Display.getPrivilegedBoolean("LWJGL_DISABLE_XRANDR")) {
            return false;
        }
        LinuxDisplay.lockAWT();
        try {
            boolean bl;
            LinuxDisplay.incDisplay();
            try {
                bl = LinuxDisplay.nIsXrandrSupported();
            }
            catch (Throwable throwable) {
                try {
                    LinuxDisplay.decDisplay();
                    throw throwable;
                }
                catch (LWJGLException e) {
                    LWJGLUtil.log("Got exception while querying Xrandr support: " + e);
                    boolean bl2 = false;
                    return bl2;
                }
            }
            LinuxDisplay.decDisplay();
            return bl;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native boolean nIsXrandrSupported() throws LWJGLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isXF86VidModeSupported() {
        LinuxDisplay.lockAWT();
        try {
            boolean bl;
            LinuxDisplay.incDisplay();
            try {
                bl = LinuxDisplay.nIsXF86VidModeSupported();
            }
            catch (Throwable throwable) {
                try {
                    LinuxDisplay.decDisplay();
                    throw throwable;
                }
                catch (LWJGLException e) {
                    LWJGLUtil.log("Got exception while querying XF86VM support: " + e);
                    boolean bl2 = false;
                    return bl2;
                }
            }
            LinuxDisplay.decDisplay();
            return bl;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native boolean nIsXF86VidModeSupported() throws LWJGLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isNetWMFullscreenSupported() throws LWJGLException {
        if (Display.getPrivilegedBoolean("LWJGL_DISABLE_NETWM")) {
            return false;
        }
        LinuxDisplay.lockAWT();
        try {
            boolean bl;
            LinuxDisplay.incDisplay();
            try {
                bl = LinuxDisplay.nIsNetWMFullscreenSupported();
            }
            catch (Throwable throwable) {
                try {
                    LinuxDisplay.decDisplay();
                    throw throwable;
                }
                catch (LWJGLException e) {
                    LWJGLUtil.log("Got exception while querying NetWM support: " + e);
                    boolean bl2 = false;
                    return bl2;
                }
            }
            LinuxDisplay.decDisplay();
            return bl;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native boolean nIsNetWMFullscreenSupported() throws LWJGLException;

    static synchronized void lockAWT() {
        Thread this_thread = Thread.currentThread();
        while (current_awt_lock_owner != null && current_awt_lock_owner != this_thread) {
            try {
                (class$org$lwjgl$opengl$LinuxDisplay == null ? LinuxDisplay.class$("org.lwjgl.opengl.LinuxDisplay") : class$org$lwjgl$opengl$LinuxDisplay).wait();
            }
            catch (InterruptedException e) {
                LWJGLUtil.log("Interrupted while waiting for awt lock: " + e);
            }
        }
        if (awt_lock_count == 0) {
            current_awt_lock_owner = this_thread;
            try {
                LinuxDisplay.nLockAWT();
            }
            catch (LWJGLException e) {
                LWJGLUtil.log("Caught exception while locking AWT: " + e);
            }
        }
        ++awt_lock_count;
    }

    private static native void nLockAWT() throws LWJGLException;

    static synchronized void unlockAWT() {
        if (awt_lock_count <= 0) {
            throw new IllegalStateException("AWT not locked!");
        }
        if (Thread.currentThread() != current_awt_lock_owner) {
            throw new IllegalStateException("AWT already locked by " + current_awt_lock_owner);
        }
        if (--awt_lock_count == 0) {
            try {
                LinuxDisplay.nUnlockAWT();
            }
            catch (LWJGLException e) {
                LWJGLUtil.log("Caught exception while unlocking AWT: " + e);
            }
            current_awt_lock_owner = null;
            LinuxDisplay.class.notify();
        }
    }

    private static native void nUnlockAWT() throws LWJGLException;

    static void incDisplay() throws LWJGLException {
        if (display_connection_usage_count == 0) {
            GLContext.loadOpenGLLibrary();
            LinuxDisplay.openDisplay();
        }
        ++display_connection_usage_count;
    }

    static void decDisplay() {
        if (--display_connection_usage_count < 0) {
            throw new InternalError("display_connection_usage_count < 0: " + display_connection_usage_count);
        }
        if (display_connection_usage_count == 0) {
            LinuxDisplay.closeDisplay();
            GLContext.unloadOpenGLLibrary();
        }
    }

    private static native void openDisplay() throws LWJGLException;

    private static native void closeDisplay();

    private int getWindowMode(boolean fullscreen) throws LWJGLException {
        if (fullscreen) {
            if (this.current_displaymode_extension == 10 && LinuxDisplay.isNetWMFullscreenSupported()) {
                LWJGLUtil.log("Using NetWM for fullscreen window");
                return 2;
            }
            LWJGLUtil.log("Using legacy mode for fullscreen window");
            return 1;
        }
        return 3;
    }

    private static native long getDisplay();

    private static native int getScreen();

    private static native long getWindow();

    private void ungrabKeyboard() {
        if (this.keyboard_grabbed) {
            LinuxDisplay.nUngrabKeyboard(LinuxDisplay.getDisplay());
            this.keyboard_grabbed = false;
        }
    }

    private static native int nUngrabKeyboard(long var0);

    private void grabKeyboard() {
        int res;
        if (!this.keyboard_grabbed && (res = LinuxDisplay.nGrabKeyboard(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow())) == 0) {
            this.keyboard_grabbed = true;
        }
    }

    private static native int nGrabKeyboard(long var0, long var2);

    private void grabPointer() {
        int result;
        if (!this.pointer_grabbed && (result = LinuxDisplay.nGrabPointer(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow())) == 0) {
            this.pointer_grabbed = true;
            if (this.isLegacyFullscreen()) {
                LinuxDisplay.nSetViewPort(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow(), LinuxDisplay.getScreen());
            }
        }
    }

    private static native int nGrabPointer(long var0, long var2);

    private static native void nSetViewPort(long var0, long var2, int var4);

    private void ungrabPointer() {
        if (this.pointer_grabbed) {
            this.pointer_grabbed = false;
            LinuxDisplay.nUngrabPointer(LinuxDisplay.getDisplay());
        }
    }

    private static native int nUngrabPointer(long var0);

    private boolean isFullscreen() {
        return current_window_mode == 1 || current_window_mode == 2;
    }

    private boolean shouldGrab() {
        return !this.input_released && this.grab;
    }

    private void updatePointerGrab() {
        if (this.isFullscreen() || this.shouldGrab()) {
            this.grabPointer();
        } else {
            this.ungrabPointer();
        }
        this.updateCursor();
    }

    private void updateCursor() {
        ByteBuffer cursor = this.shouldGrab() ? this.blank_cursor : this.current_cursor;
        LinuxDisplay.nDefineCursor(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow(), cursor);
    }

    private static native void nDefineCursor(long var0, long var2, ByteBuffer var4);

    private boolean isLegacyFullscreen() {
        return current_window_mode == 1;
    }

    private void updateKeyboardGrab() {
        if (this.isLegacyFullscreen()) {
            this.grabKeyboard();
        } else {
            this.ungrabKeyboard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createWindow(DisplayMode mode, boolean fullscreen, int x, int y) throws LWJGLException {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.incDisplay();
            try {
                ByteBuffer handle = this.peer_info.lockAndGetHandle();
                try {
                    current_window_mode = this.getWindowMode(fullscreen);
                    LinuxDisplay.nCreateWindow(handle, mode, current_window_mode, x, y);
                    this.blank_cursor = LinuxDisplay.createBlankCursor();
                    this.current_cursor = null;
                    this.focused = true;
                    this.input_released = false;
                    this.pointer_grabbed = false;
                    this.keyboard_grabbed = false;
                    this.close_requested = false;
                    this.grab = false;
                    this.minimized = false;
                    this.dirty = true;
                    this.updateInputGrab();
                    LinuxDisplay.nSetRepeatMode(LinuxDisplay.getDisplay(), 0);
                }
                finally {
                    this.peer_info.unlock();
                }
            }
            catch (LWJGLException e) {
                LinuxDisplay.decDisplay();
                throw e;
            }
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native void nCreateWindow(ByteBuffer var0, DisplayMode var1, int var2, int var3, int var4) throws LWJGLException;

    private void updateInputGrab() {
        this.updatePointerGrab();
        this.updateKeyboardGrab();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyWindow() {
        LinuxDisplay.lockAWT();
        try {
            try {
                this.setNativeCursor(null);
            }
            catch (LWJGLException e) {
                LWJGLUtil.log("Failed to reset cursor: " + e.getMessage());
            }
            LinuxDisplay.nDestroyCursor(this.blank_cursor);
            this.blank_cursor = null;
            this.ungrabKeyboard();
            LinuxDisplay.nDestroyWindow();
            LinuxDisplay.nSetRepeatMode(LinuxDisplay.getDisplay(), 2);
            LinuxDisplay.decDisplay();
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native void nDestroyWindow();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchDisplayMode(DisplayMode mode) throws LWJGLException {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.nSwitchDisplayMode(LinuxDisplay.getScreen(), this.current_displaymode_extension, mode);
            this.current_mode = mode;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native void nSwitchDisplayMode(int var0, int var1, DisplayMode var2) throws LWJGLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDisplayMode() {
        LinuxDisplay.lockAWT();
        try {
            this.switchDisplayMode(this.saved_mode);
            if (LinuxDisplay.isXF86VidModeSupported()) {
                this.doSetGamma(this.saved_gamma);
            }
        }
        catch (LWJGLException e) {
            LWJGLUtil.log("Caught exception while resetting mode: " + e);
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int getGammaRampLength() {
        if (!LinuxDisplay.isXF86VidModeSupported()) {
            return 0;
        }
        LinuxDisplay.lockAWT();
        try {
            int n;
            LinuxDisplay.incDisplay();
            try {
                n = LinuxDisplay.nGetGammaRampLength(LinuxDisplay.getDisplay(), LinuxDisplay.getScreen());
            }
            catch (LWJGLException e) {
                LWJGLUtil.log("Got exception while querying gamma length: " + e);
                int n2 = 0;
                LinuxDisplay.decDisplay();
                LinuxDisplay.unlockAWT();
                return n2;
                {
                    catch (Throwable throwable) {
                        try {
                            LinuxDisplay.decDisplay();
                            throw throwable;
                        }
                        catch (LWJGLException e2) {
                            LWJGLUtil.log("Failed to get gamma ramp length: " + e2);
                            int n3 = 0;
                            return n3;
                        }
                    }
                }
            }
            LinuxDisplay.decDisplay();
            return n;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native int nGetGammaRampLength(long var0, int var2) throws LWJGLException;

    public void setGammaRamp(FloatBuffer gammaRamp) throws LWJGLException {
        if (!LinuxDisplay.isXF86VidModeSupported()) {
            throw new LWJGLException("No gamma ramp support (Missing XF86VM extension)");
        }
        this.doSetGamma(LinuxDisplay.convertToNativeRamp(gammaRamp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSetGamma(ByteBuffer native_gamma) throws LWJGLException {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.nSetGammaRamp(LinuxDisplay.getScreen(), native_gamma);
            this.current_gamma = native_gamma;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native void nSetGammaRamp(int var0, ByteBuffer var1) throws LWJGLException;

    private static ByteBuffer convertToNativeRamp(FloatBuffer ramp) throws LWJGLException {
        return LinuxDisplay.nConvertToNativeRamp(ramp, ramp.position(), ramp.remaining());
    }

    private static native ByteBuffer nConvertToNativeRamp(FloatBuffer var0, int var1, int var2) throws LWJGLException;

    public String getAdapter() {
        return null;
    }

    public String getVersion() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayMode init() throws LWJGLException {
        LinuxDisplay.lockAWT();
        try {
            this.current_displaymode_extension = LinuxDisplay.getBestDisplayModeExtension();
            if (this.current_displaymode_extension == 12) {
                throw new LWJGLException("No display mode extension is available");
            }
            DisplayMode[] modes = this.getAvailableDisplayModes();
            if (modes == null || modes.length == 0) {
                throw new LWJGLException("No modes available");
            }
            switch (this.current_displaymode_extension) {
                case 10: {
                    this.saved_mode = LinuxDisplay.getCurrentXRandrMode();
                    break;
                }
                case 11: {
                    this.saved_mode = modes[0];
                    break;
                }
                default: {
                    throw new LWJGLException("Unknown display mode extension: " + this.current_displaymode_extension);
                }
            }
            this.current_mode = this.saved_mode;
            this.current_gamma = this.saved_gamma = LinuxDisplay.getCurrentGammaRamp();
            DisplayMode displayMode = this.saved_mode;
            return displayMode;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DisplayMode getCurrentXRandrMode() throws LWJGLException {
        LinuxDisplay.lockAWT();
        try {
            DisplayMode displayMode;
            LinuxDisplay.incDisplay();
            try {
                displayMode = LinuxDisplay.nGetCurrentXRandrMode();
            }
            catch (Throwable throwable) {
                LinuxDisplay.decDisplay();
                throw throwable;
            }
            LinuxDisplay.decDisplay();
            return displayMode;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native DisplayMode nGetCurrentXRandrMode() throws LWJGLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTitle(String title) {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.nSetTitle(title);
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native void nSetTitle(String var0);

    public boolean isCloseRequested() {
        boolean result = this.close_requested;
        this.close_requested = false;
        return result;
    }

    public boolean isVisible() {
        return !this.minimized;
    }

    public boolean isActive() {
        return this.focused || this.isLegacyFullscreen();
    }

    public boolean isDirty() {
        boolean result = this.dirty;
        this.dirty = false;
        return result;
    }

    public PeerInfo createPeerInfo(PixelFormat pixel_format) throws LWJGLException {
        this.peer_info = new LinuxDisplayPeerInfo(pixel_format);
        return this.peer_info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        LinuxDisplay.lockAWT();
        try {
            this.nUpdate();
            this.checkInput();
        }
        catch (LWJGLException e) {
            LWJGLUtil.log("Caught exception while processing messages: " + e);
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private native void nUpdate() throws LWJGLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reshape(int x, int y, int width, int height) {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.nReshape(x, y, width, height);
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native void nReshape(int var0, int var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayMode[] getAvailableDisplayModes() throws LWJGLException {
        LinuxDisplay.lockAWT();
        try {
            DisplayMode[] displayModeArray;
            LinuxDisplay.incDisplay();
            try {
                DisplayMode[] modes;
                displayModeArray = modes = LinuxDisplay.nGetAvailableDisplayModes(this.current_displaymode_extension);
            }
            catch (Throwable throwable) {
                LinuxDisplay.decDisplay();
                throw throwable;
            }
            LinuxDisplay.decDisplay();
            return displayModeArray;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native DisplayMode[] nGetAvailableDisplayModes(int var0) throws LWJGLException;

    public boolean hasWheel() {
        return true;
    }

    public int getButtonCount() {
        return this.mouse.getButtonCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMouse() {
        LinuxDisplay.lockAWT();
        try {
            this.mouse = new LinuxMouse(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow());
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    public void destroyMouse() {
        this.mouse = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollMouse(IntBuffer coord_buffer, ByteBuffer buttons) {
        this.update();
        LinuxDisplay.lockAWT();
        try {
            this.mouse.poll(this.grab, coord_buffer, buttons);
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readMouse(ByteBuffer buffer) {
        this.update();
        LinuxDisplay.lockAWT();
        try {
            this.mouse.read(buffer);
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursorPosition(int x, int y) {
        LinuxDisplay.lockAWT();
        try {
            this.mouse.setCursorPosition(x, y);
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private void checkInput() {
        boolean bl = this.focused = LinuxDisplay.nGetInputFocus(LinuxDisplay.getDisplay()) == LinuxDisplay.getWindow();
        if (this.focused) {
            this.acquireInput();
        } else {
            this.releaseInput();
        }
    }

    private static native long nGetInputFocus(long var0);

    private void releaseInput() {
        if (this.isLegacyFullscreen() || this.input_released) {
            return;
        }
        this.input_released = true;
        LinuxDisplay.nSetRepeatMode(LinuxDisplay.getDisplay(), 2);
        this.updateInputGrab();
        if (current_window_mode == 2) {
            LinuxDisplay.nIconifyWindow(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow(), LinuxDisplay.getScreen());
            try {
                LinuxDisplay.nSwitchDisplayMode(LinuxDisplay.getScreen(), this.current_displaymode_extension, this.saved_mode);
                LinuxDisplay.nSetGammaRamp(LinuxDisplay.getScreen(), this.saved_gamma);
            }
            catch (LWJGLException e) {
                LWJGLUtil.log("Failed to restore saved mode: " + e.getMessage());
            }
        }
    }

    private static native void nIconifyWindow(long var0, long var2, int var4);

    private void acquireInput() {
        if (this.isLegacyFullscreen() || !this.input_released) {
            return;
        }
        this.input_released = false;
        LinuxDisplay.nSetRepeatMode(LinuxDisplay.getDisplay(), 0);
        this.updateInputGrab();
        if (current_window_mode == 2) {
            try {
                LinuxDisplay.nSwitchDisplayMode(LinuxDisplay.getScreen(), this.current_displaymode_extension, this.current_mode);
                LinuxDisplay.nSetGammaRamp(LinuxDisplay.getScreen(), this.current_gamma);
            }
            catch (LWJGLException e) {
                LWJGLUtil.log("Failed to restore mode: " + e.getMessage());
            }
        }
    }

    private static native void nSetRepeatMode(long var0, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grabMouse(boolean new_grab) {
        LinuxDisplay.lockAWT();
        try {
            if (new_grab != this.grab) {
                this.grab = new_grab;
                this.updateInputGrab();
                this.mouse.changeGrabbed(this.grab, this.pointer_grabbed, this.shouldGrab());
            }
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNativeCursorCapabilities() {
        LinuxDisplay.lockAWT();
        try {
            int n;
            LinuxDisplay.incDisplay();
            try {
                n = LinuxDisplay.nGetNativeCursorCapabilities();
            }
            catch (Throwable throwable) {
                try {
                    LinuxDisplay.decDisplay();
                    throw throwable;
                }
                catch (LWJGLException e) {
                    throw new RuntimeException(e);
                }
            }
            LinuxDisplay.decDisplay();
            return n;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native int nGetNativeCursorCapabilities() throws LWJGLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNativeCursor(Object handle) throws LWJGLException {
        this.current_cursor = (ByteBuffer)handle;
        LinuxDisplay.lockAWT();
        try {
            this.updateCursor();
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMinCursorSize() {
        LinuxDisplay.lockAWT();
        try {
            int n;
            LinuxDisplay.incDisplay();
            try {
                n = LinuxDisplay.nGetMinCursorSize();
            }
            catch (Throwable throwable) {
                try {
                    LinuxDisplay.decDisplay();
                    throw throwable;
                }
                catch (LWJGLException e) {
                    LWJGLUtil.log("Exception occurred in getMinCursorSize: " + e);
                    int n2 = 0;
                    return n2;
                }
            }
            LinuxDisplay.decDisplay();
            return n;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native int nGetMinCursorSize();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxCursorSize() {
        LinuxDisplay.lockAWT();
        try {
            int n;
            LinuxDisplay.incDisplay();
            try {
                n = LinuxDisplay.nGetMaxCursorSize();
            }
            catch (Throwable throwable) {
                try {
                    LinuxDisplay.decDisplay();
                    throw throwable;
                }
                catch (LWJGLException e) {
                    LWJGLUtil.log("Exception occurred in getMaxCursorSize: " + e);
                    int n2 = 0;
                    return n2;
                }
            }
            LinuxDisplay.decDisplay();
            return n;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native int nGetMaxCursorSize();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createKeyboard() throws LWJGLException {
        LinuxDisplay.lockAWT();
        try {
            this.keyboard = new LinuxKeyboard(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow());
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyKeyboard() {
        LinuxDisplay.lockAWT();
        try {
            this.keyboard.destroy();
            this.keyboard = null;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollKeyboard(ByteBuffer keyDownBuffer) {
        this.update();
        LinuxDisplay.lockAWT();
        try {
            this.keyboard.poll(keyDownBuffer);
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readKeyboard(ByteBuffer buffer) {
        this.update();
        LinuxDisplay.lockAWT();
        try {
            this.keyboard.read(buffer);
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native ByteBuffer nCreateCursor(int var0, int var1, int var2, int var3, int var4, IntBuffer var5, int var6, IntBuffer var7, int var8) throws LWJGLException;

    private static ByteBuffer createBlankCursor() {
        return LinuxDisplay.nCreateBlankCursor(LinuxDisplay.getDisplay(), LinuxDisplay.getWindow());
    }

    private static native ByteBuffer nCreateBlankCursor(long var0, long var2);

    public Object createCursor(int width, int height, int xHotspot, int yHotspot, int numImages, IntBuffer images, IntBuffer delays) throws LWJGLException {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.incDisplay();
            try {
                ByteBuffer byteBuffer = LinuxDisplay.nCreateCursor(width, height, xHotspot, yHotspot, numImages, images, images.position(), delays, delays != null ? delays.position() : -1);
                return byteBuffer;
            }
            catch (LWJGLException e) {
                LinuxDisplay.decDisplay();
                throw e;
            }
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyCursor(Object cursorHandle) {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.nDestroyCursor(cursorHandle);
            LinuxDisplay.decDisplay();
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native void nDestroyCursor(Object var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPbufferCapabilities() {
        LinuxDisplay.lockAWT();
        try {
            int n;
            LinuxDisplay.incDisplay();
            try {
                n = LinuxDisplay.nGetPbufferCapabilities();
            }
            catch (Throwable throwable) {
                try {
                    LinuxDisplay.decDisplay();
                    throw throwable;
                }
                catch (LWJGLException e) {
                    LWJGLUtil.log("Exception occurred in getPbufferCapabilities: " + e);
                    int n2 = 0;
                    return n2;
                }
            }
            LinuxDisplay.decDisplay();
            return n;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native int nGetPbufferCapabilities();

    public boolean isBufferLost(PeerInfo handle) {
        return false;
    }

    public PeerInfo createPbuffer(int width, int height, PixelFormat pixel_format, IntBuffer pixelFormatCaps, IntBuffer pBufferAttribs) throws LWJGLException {
        return new LinuxPbufferPeerInfo(width, height, pixel_format);
    }

    public void setPbufferAttrib(PeerInfo handle, int attrib, int value) {
        throw new UnsupportedOperationException();
    }

    public void bindTexImageToPbuffer(PeerInfo handle, int buffer) {
        throw new UnsupportedOperationException();
    }

    public void releaseTexImageFromPbuffer(PeerInfo handle, int buffer) {
        throw new UnsupportedOperationException();
    }

    private static ByteBuffer convertIcon(ByteBuffer icon, int width, int height) {
        ByteBuffer icon_copy = BufferUtils.createByteBuffer(icon.capacity());
        int x = 0;
        int y = 5;
        int depth = 4;
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                byte r = icon.get(x * 4 + y * width * 4);
                byte g = icon.get(x * 4 + y * width * 4 + 1);
                byte b = icon.get(x * 4 + y * width * 4 + 2);
                byte a = icon.get(x * 4 + y * width * 4 + 3);
                icon_copy.put(x * depth + y * width * depth, b);
                icon_copy.put(x * depth + y * width * depth + 1, g);
                icon_copy.put(x * depth + y * width * depth + 2, r);
                icon_copy.put(x * depth + y * width * depth + 3, a);
            }
        }
        return icon_copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setIcon(ByteBuffer[] icons) {
        LinuxDisplay.lockAWT();
        try {
            int i;
            block10: {
                int n;
                LinuxDisplay.incDisplay();
                try {
                    i = 0;
                    if (i >= icons.length) break block10;
                    int size = icons[i].limit() / 4;
                    int dimension = (int)Math.sqrt(size);
                    ByteBuffer icon = LinuxDisplay.convertIcon(icons[i], dimension, dimension);
                    LinuxDisplay.nSetWindowIcon(icon, icon.capacity(), dimension, dimension);
                    n = 1;
                }
                catch (Throwable throwable) {
                    try {
                        LinuxDisplay.decDisplay();
                        throw throwable;
                    }
                    catch (LWJGLException e) {
                        LWJGLUtil.log("Failed to set display icon: " + e);
                        int n2 = 0;
                        return n2;
                    }
                }
                LinuxDisplay.decDisplay();
                return n;
            }
            i = 0;
            LinuxDisplay.decDisplay();
            return i;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native void nSetWindowIcon(ByteBuffer var0, int var1, int var2, int var3);

    private void handleButtonEvent(long millis, int type, int button, int state) {
        if (this.mouse != null) {
            this.mouse.handleButtonEvent(this.grab, millis, type, (byte)button);
        }
    }

    private void handleKeyEvent(long event_ptr, long millis, int type, int keycode, int state) {
        if (this.keyboard != null) {
            this.keyboard.handleKeyEvent(event_ptr, millis, type, keycode, state);
        }
    }

    private void handlePointerMotionEvent(long millis, long root_window, int x_root, int y_root, int x, int y, int state) {
        if (this.mouse != null) {
            this.mouse.handlePointerMotion(this.grab, this.pointer_grabbed, this.shouldGrab(), millis, root_window, x_root, y_root, x, y);
        }
    }

    private void handleWarpEvent(int x, int y) {
        if (this.mouse != null) {
            this.mouse.handleWarpEvent(x, y);
        }
    }

    private void handleExposeEvent() {
        this.dirty = true;
    }

    private void handleUnmapNotifyEvent() {
        this.dirty = true;
        this.minimized = true;
    }

    private void handleMapNotifyEvent() {
        this.dirty = true;
        this.minimized = false;
    }

    private void handleCloseEvent() {
        this.close_requested = true;
    }

    static {
        display_connection_usage_count = 0;
    }
}

