/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt.reg;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import org.newdawn.tilt.reg.PostListener;
import org.newdawn.util.Log;

public class PostConnection {
    private String url;
    private String attributes;
    private PostListener listener;

    public PostConnection(String url, PostListener listener) {
        this.url = url;
        this.listener = listener;
        this.attributes = "";
    }

    public void addAttribute(String name, String key) {
        this.attributes = this.attributes + name + "=" + key + "&";
    }

    public void post() {
        Thread t = new Thread(){

            public void run() {
                PostConnection.this.postImpl();
            }
        };
        t.start();
    }

    public void postImpl() {
        try {
            String line;
            URL u = new URL(this.url);
            URLConnection connection = u.openConnection();
            connection.setRequestProperty("Cache-Control", "no-cache");
            connection.setRequestProperty("Pragma", "no-cache");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            PrintStream pout = new PrintStream(connection.getOutputStream());
            pout.println(this.attributes);
            pout.flush();
            pout.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String result = null;
            while ((line = reader.readLine()) != null) {
                if (result == null) {
                    result = line;
                }
                this.listener.reportLine(line);
            }
            reader.close();
            if (result == null || result.startsWith("failed")) {
                this.listener.failed();
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            this.listener.failed();
        }
    }
}

