/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt.physics;

import java.util.ArrayList;
import org.newdawn.render.util.Tuple2;
import org.newdawn.tilt.geom.CollisionResult;
import org.newdawn.tilt.physics.Body;
import org.newdawn.tilt.physics.DynamicBody;
import org.newdawn.tilt.physics.SpaceListener;

public class Space {
    private ArrayList staticBodies = new ArrayList();
    private ArrayList dynamicBodies = new ArrayList();
    private float gravityX;
    private float gravityY;
    private SpaceListener listener;
    private CollisionResult result = new CollisionResult();
    private Tuple2 velocity = new Tuple2(0.0f, 0.0f);
    private Tuple2 perp = new Tuple2(0.0f, 0.0f);
    private Tuple2 frictionVector = new Tuple2(0.0f, 0.0f);
    private Tuple2 bounceVector = new Tuple2(0.0f, 0.0f);
    private Tuple2 temp = new Tuple2(0.0f, 0.0f);
    private Tuple2 bestNormal = new Tuple2(0.0f, 0.0f);

    public Space(SpaceListener listener) {
        this.listener = listener;
    }

    public void getBodies(ArrayList list) {
        list.clear();
        list.addAll(this.staticBodies);
        list.addAll(this.dynamicBodies);
    }

    public void setGravity(float x, float y) {
        this.gravityX = x;
        this.gravityY = y;
    }

    public float getGravityX() {
        return this.gravityX;
    }

    public float getGravityY() {
        return this.gravityY;
    }

    public void addAsStatic(DynamicBody body) {
        this.staticBodies.add(body);
    }

    public void add(Body body) {
        if (body instanceof DynamicBody) {
            this.dynamicBodies.add(body);
        } else {
            this.staticBodies.add(body);
        }
    }

    public void remove(Body body) {
        this.staticBodies.remove(body);
        this.dynamicBodies.remove(body);
    }

    public void update(int delta) {
        for (int i = 0; i < this.dynamicBodies.size(); ++i) {
            ((DynamicBody)this.dynamicBodies.get(i)).update(this, delta);
        }
    }

    Body checkForCollision(DynamicBody body) {
        boolean bounce;
        Body current;
        int i;
        Body hitBody = null;
        float deepestHit = -1.0f;
        int count = 0;
        for (i = 0; i < this.staticBodies.size(); ++i) {
            current = (Body)this.staticBodies.get(i);
            if (current == body || !current.isActive()) continue;
            this.result.missed();
            current.getShape().collides(body.getVelocityX(), body.getVelocityY(), body.getShape(), false, this.result);
            bounce = this.result.collided();
            if (!bounce) continue;
            ++count;
            if (!(bounce &= !this.listener.hit(body, current, this.result.getPenDepth())) || !(this.result.getPenDepth() > deepestHit)) continue;
            deepestHit = this.result.getPenDepth();
            hitBody = current;
            this.bestNormal.set(this.result.getNormal());
        }
        for (i = 0; i < this.dynamicBodies.size(); ++i) {
            current = (DynamicBody)this.dynamicBodies.get(i);
            if (current == body || !current.isActive()) continue;
            this.result.missed();
            current.getShape().collides(body.getVelocityX(), body.getVelocityY(), body.getShape(), false, this.result);
            bounce = this.result.collided();
            if (!bounce || !(bounce &= !this.listener.hit(body, current, this.result.getPenDepth())) || !(this.result.getPenDepth() > deepestHit)) continue;
            deepestHit = this.result.getPenDepth();
            hitBody = current;
            this.bestNormal.set(this.result.getNormal());
        }
        if (hitBody != null) {
            hitBody.getShape().collides(body.getVelocityX(), body.getVelocityY(), body.getShape(), true, this.result);
            this.velocity.x = body.getVelocityX();
            this.velocity.y = body.getVelocityY();
            this.resolve(body, this.velocity, this.result.getNormal(), this.temp);
            body.setVelocity(this.temp.x, this.temp.y);
        }
        return hitBody;
    }

    public void resolve(DynamicBody mover, Tuple2 in, Tuple2 normal, Tuple2 result) {
        this.perp.x = normal.y;
        this.perp.y = -normal.x;
        in.projectOntoUnit(this.perp, this.frictionVector);
        in.scale(-1.0f);
        in.projectOntoUnit(normal, this.bounceVector);
        this.bounceVector.scale(mover.getBounce());
        this.frictionVector.scale(mover.getFriction());
        this.bounceVector.add(this.frictionVector);
        result.set(this.bounceVector);
    }

    Body checkForCollision_THEOLDWAY(DynamicBody body) {
        Body current;
        int i;
        Body hitBody = null;
        int count = 0;
        for (i = 0; i < this.staticBodies.size(); ++i) {
            current = (Body)this.staticBodies.get(i);
            if (current == body || !current.isActive()) continue;
            this.result.missed();
            current.getShape().collides(body.getVelocityX(), body.getVelocityY(), body.getShape(), true, this.result);
            boolean bounce = this.result.collided();
            if (!bounce) continue;
            ++count;
            if (!(bounce &= !this.listener.hit(body, current, this.result.getPenDepth()))) continue;
            hitBody = current;
            this.velocity.x = body.getVelocityX();
            this.velocity.y = body.getVelocityY();
            this.resolve(body, this.velocity, this.result.getNormal(), this.temp);
            body.setVelocity(this.temp.x, this.temp.y);
        }
        for (i = 0; i < this.dynamicBodies.size(); ++i) {
            current = (DynamicBody)this.dynamicBodies.get(i);
            if (current == body || !current.isActive()) continue;
            Body bodyA = current;
            DynamicBody bodyB = body;
            this.result.missed();
            bodyA.getShape().collides(body.getVelocityX(), body.getVelocityY(), body.getShape(), false, this.result);
            boolean bounce = this.result.collided();
            if (!bounce || !(bounce &= !this.listener.hit(body, current, this.result.getPenDepth()))) continue;
            body.undoMove();
            hitBody = current;
            if (body.pushable()) {
                this.velocity.x = body.getVelocityX();
                this.velocity.y = body.getVelocityY();
                this.resolve(body, this.velocity, this.result.getNormal(), this.temp);
                body.setVelocity(this.temp.x, this.temp.y);
            } else {
                body.setVelocity(0.0f, 0.0f);
            }
            return current;
        }
        return hitBody;
    }
}

