/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt.physics;

import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;
import org.newdawn.tilt.physics.DynamicBodyListener;
import org.newdawn.tilt.physics.Space;

public class DynamicBody
extends Body {
    protected float vx;
    protected float vy;
    protected float scalar = 0.01f;
    protected float bounce;
    protected float friction;
    protected boolean pushable = true;
    protected DynamicBodyListener listener;
    protected boolean moving;
    protected boolean collide;
    private float oldx;
    private float oldy;

    public DynamicBody(Shape shape) {
        this(shape, 0.4f, 1.0f);
    }

    public DynamicBody(Shape shape, float bounce, float friction) {
        super(shape);
        this.bounce = bounce;
        this.friction = friction;
        this.collide = true;
    }

    public void setListener(DynamicBodyListener listener) {
        this.listener = listener;
    }

    public void setCollide(boolean collide) {
        this.collide = collide;
    }

    public boolean pushable() {
        return this.pushable;
    }

    public void setPushable(boolean pushable) {
        this.pushable = pushable;
    }

    public float getBounce() {
        return this.bounce;
    }

    public float getFriction() {
        return this.friction;
    }

    public void undoMove() {
        this.shape.setX(this.oldx);
        this.shape.setY(this.oldy);
    }

    public void update(Space space, int delta) {
        float gx = space.getGravityX();
        float gy = space.getGravityY();
        this.oldx = this.shape.getX();
        this.oldy = this.shape.getY();
        float t = (float)delta * this.scalar;
        float nx = this.oldx + this.vx * t;
        float ny = this.oldy + this.vy * t;
        this.shape.setX(nx);
        this.shape.setY(ny);
        if (this.collide) {
            Body other = space.checkForCollision(this);
            if (other == null) {
                this.moving = true;
                this.vx += gx * (t * t);
                this.vy += gy * (t * t);
            } else {
                if (this.listener != null && this.moving) {
                    this.listener.hit(other);
                }
                this.moving = false;
            }
        } else {
            this.moving = true;
            this.vx += gx * (t * t);
            this.vy += gy * (t * t);
        }
    }

    public float getSpeed() {
        return (float)Math.sqrt(this.vx * this.vx + this.vy * this.vy);
    }

    void adjustVelocity(float x, float y) {
        this.vx += x;
        this.vy += y;
    }

    public float getVelocityX() {
        return this.vx;
    }

    public float getVelocityY() {
        return this.vy;
    }

    public void setVelocity(float x, float y) {
        this.vx = x;
        this.vy = y;
    }

    public void stop() {
        this.vx = 0.0f;
        this.vy = 0.0f;
    }

    public void scaleVelocity(float f) {
        this.vx *= f;
        this.vy *= f;
    }

    public String toString() {
        return "DynBody: " + this.shape;
    }
}

