/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt.geom.collide;

import org.newdawn.render.util.Tuple2;
import org.newdawn.tilt.geom.Capsule;
import org.newdawn.tilt.geom.Circle;
import org.newdawn.tilt.geom.CollisionResult;
import org.newdawn.tilt.geom.collide.Util;

public class CircleCapsuleCollision {
    private static Tuple2 center = new Tuple2(0.0f, 0.0f);
    private static Tuple2 pt = new Tuple2(0.0f, 0.0f);

    public static void collides(float vx, float vy, Capsule fixed, Circle mover, boolean fix, CollisionResult result) {
        center.set(mover.getX(), mover.getY());
        float dSq = fixed.getLine().distanceSquared(center);
        float radiusSq = fixed.getRadius() + mover.getRadius();
        radiusSq *= radiusSq;
        if (dSq < radiusSq) {
            fixed.getLine().getClosestPoint(center, pt);
            float penDepth = 0.0f;
            float radius = fixed.getRadius() + mover.getRadius();
            penDepth = Util.moveAway(mover, CircleCapsuleCollision.pt.x, CircleCapsuleCollision.pt.y, radius, fix);
            result.hit(CircleCapsuleCollision.pt.x - CircleCapsuleCollision.center.x, CircleCapsuleCollision.pt.y - CircleCapsuleCollision.center.y, penDepth);
            return;
        }
        result.missed();
    }

    public static void collides(float vx, float vy, Circle fixed, Capsule mover, boolean fix, CollisionResult result) {
        center.set(fixed.getX(), fixed.getY());
        float dSq = mover.getLine().distanceSquared(center);
        float radiusSq = fixed.getRadius() + mover.getRadius();
        radiusSq *= radiusSq;
        if (dSq < radiusSq) {
            mover.getLine().getClosestPoint(center, pt);
            float penDepth = 0.0f;
            float nx = CircleCapsuleCollision.pt.x - CircleCapsuleCollision.center.x;
            float ny = CircleCapsuleCollision.pt.y - CircleCapsuleCollision.center.y;
            float radius = fixed.getRadius() + mover.getRadius();
            penDepth = Util.moveAway(mover, mover.getLine().getX1() - nx, mover.getLine().getY1() - ny, radius, fix);
            result.hit(nx, ny, penDepth);
            return;
        }
        result.missed();
    }
}

