/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt.geom.collide;

import org.newdawn.render.util.Tuple2;
import org.newdawn.tilt.geom.AABox;
import org.newdawn.tilt.geom.Circle;
import org.newdawn.tilt.geom.CollisionResult;
import org.newdawn.tilt.geom.collide.Util;

public class AABoxCircleCollision {
    public static void collides(float vx, float vy, Circle fixed, AABox mover, boolean fix, CollisionResult result) {
        float cx = fixed.getX();
        float cy = fixed.getY();
        AABoxCircleCollision.collides(vx, vy, mover, fixed, fix, result);
        float dx = fixed.getX() - cx;
        float dy = fixed.getY() - cy;
        fixed.setX(cx);
        fixed.setY(cy);
        if (!result.collided()) {
            return;
        }
        mover.setX(mover.getX() - dx);
        mover.setY(mover.getY() - dy);
        Tuple2 norm = result.getNormal();
        norm.scale(-1.0f);
        result.hit(norm.x, norm.y, -result.getPenDepth());
    }

    public static void collides(float vx, float vy, AABox fixed, Circle mover, boolean fix, CollisionResult result) {
        fixed.collides(vx, vy, mover.getBoundingBox(), false, result);
        if (!result.collided()) {
            return;
        }
        float cornerOffset = 0.02f;
        if (mover.getX() <= fixed.getX() && mover.getY() <= fixed.getY()) {
            boolean inside = mover.inside(fixed.getX(), fixed.getY());
            if (inside) {
                float depth = 0.0f;
                depth = Util.moveAway(mover, fixed.getX(), fixed.getY(), mover.getRadius(), fix);
                result.hit(-1.0f, -1.0f, depth);
                return;
            }
            result.missed();
            return;
        }
        if (mover.getX() <= fixed.getX() && mover.getY() >= fixed.getY2()) {
            boolean inside = mover.inside(fixed.getX(), fixed.getY2());
            if (inside) {
                float depth = 0.0f;
                depth = Util.moveAway(mover, fixed.getX(), fixed.getY2(), mover.getRadius(), fix);
                result.hit(-1.0f, 1.0f, depth);
                return;
            }
            result.missed();
            return;
        }
        if (mover.getX() >= fixed.getX2() && mover.getY() <= fixed.getY()) {
            boolean inside = mover.inside(fixed.getX2(), fixed.getY());
            if (inside) {
                float depth = 0.0f;
                depth = Util.moveAway(mover, fixed.getX2(), fixed.getY(), mover.getRadius(), fix);
                result.hit(1.0f, -1.0f, depth);
                return;
            }
            result.missed();
            return;
        }
        if (mover.getX() >= fixed.getX2() && mover.getY() >= fixed.getY2()) {
            boolean inside = mover.inside(fixed.getX2(), fixed.getY2());
            if (inside) {
                float depth = 0.0f;
                depth = Util.moveAway(mover, fixed.getX2(), fixed.getY2(), mover.getRadius(), fix);
                result.hit(1.0f, 1.0f, depth);
                return;
            }
            result.missed();
            return;
        }
        if (mover.getX() <= fixed.getX() && mover.getY() > fixed.getY() && mover.getY() < fixed.getY2()) {
            float depth = 0.0f;
            depth = Util.moveAway(mover, fixed.getX(), mover.getY(), mover.getRadius(), fix);
            result.hit(-1.0f, 0.0f, depth);
            return;
        }
        if (mover.getY() <= fixed.getY() && mover.getX() > fixed.getX() && mover.getX() < fixed.getX2()) {
            float depth = 0.0f;
            depth = Util.moveAway(mover, mover.getX(), fixed.getY(), mover.getRadius(), fix);
            result.hit(0.0f, -1.0f, depth);
            return;
        }
        if (mover.getX() >= fixed.getX2() && mover.getY() > fixed.getY() && mover.getY() < fixed.getY2()) {
            float depth = 0.0f;
            depth = Util.moveAway(mover, fixed.getX2(), mover.getY(), mover.getRadius(), fix);
            result.hit(1.0f, 0.0f, depth);
            return;
        }
        if (mover.getY() >= fixed.getY2() && mover.getX() > fixed.getX() && mover.getX() < fixed.getX2()) {
            float depth = 0.0f;
            depth = Util.moveAway(mover, mover.getX(), fixed.getY2(), mover.getRadius(), fix);
            result.hit(0.0f, 1.0f, depth);
            return;
        }
        result.hit(0.0f, 0.0f, 0.0f);
    }
}

