/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt.geom;

import org.newdawn.render.util.Tuple2;
import org.newdawn.tilt.geom.Circle;

public class Line {
    private Tuple2 p1;
    private Tuple2 p2;
    private Tuple2 vec;
    private float lenSquared;
    private Tuple2 loc = new Tuple2(0.0f, 0.0f);
    private Tuple2 v = new Tuple2(0.0f, 0.0f);
    private Tuple2 v2 = new Tuple2(0.0f, 0.0f);
    private Tuple2 proj = new Tuple2(0.0f, 0.0f);
    private Tuple2 temp = new Tuple2(0.0f, 0.0f);
    private Tuple2 closest = new Tuple2(0.0f, 0.0f);
    private Tuple2 other = new Tuple2(0.0f, 0.0f);

    public Line(Tuple2 p1, Tuple2 p2) {
        this.p1 = p1;
        this.p2 = p2;
        this.vec = p2.copy();
        this.vec.sub(p1);
        this.lenSquared = this.vec.length();
        this.lenSquared *= this.lenSquared;
    }

    public float getX() {
        return this.getX1();
    }

    public float getY() {
        return this.getY1();
    }

    public float getX1() {
        return this.p1.x;
    }

    public float getY1() {
        return this.p1.y;
    }

    public float getX2() {
        return this.p2.x;
    }

    public float getY2() {
        return this.p2.y;
    }

    public float distance(Tuple2 p3) {
        return (float)Math.sqrt(this.distanceSquared(p3));
    }

    public float distanceSquared(Tuple2 p3) {
        this.getClosestPoint(p3, this.closest);
        this.closest.sub(p3);
        float result = this.closest.lengthSquared();
        return result;
    }

    public void getClosestPoint(Tuple2 p3, Tuple2 result) {
        this.loc.set(p3);
        this.loc.sub(this.p1);
        this.v.set(this.vec);
        this.v2.set(this.vec);
        this.v2.scale(-1.0f);
        this.v.normalise();
        this.loc.projectOntoUnit(this.v, this.proj);
        if (this.proj.lengthSquared() > this.vec.lengthSquared()) {
            result.set(this.p2);
            return;
        }
        this.proj.add(this.p1);
        this.other.set(this.proj);
        this.other.sub(this.p2);
        if (this.other.lengthSquared() > this.vec.lengthSquared()) {
            result.set(this.p1);
            return;
        }
        result.set(this.proj);
    }

    public boolean touches(Circle circle) {
        this.temp.x = circle.getX();
        this.temp.y = circle.getY();
        float dis = this.distanceSquared(this.temp);
        return dis < circle.getRadius() * circle.getRadius();
    }
}

