/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt.geom;

import org.newdawn.tilt.geom.AABox;
import org.newdawn.tilt.geom.Capsule;
import org.newdawn.tilt.geom.CollisionResult;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.geom.collide.AABoxCircleCollision;
import org.newdawn.tilt.geom.collide.CircleCapsuleCollision;
import org.newdawn.tilt.geom.collide.CircleCircleCollision;

public class Circle
extends Shape {
    private float x;
    private float y;
    private float rad;
    private AABox box = new AABox(0.0f, 0.0f, 0.0f, 0.0f);

    public Circle(float x, float y, float rad) {
        this.x = x;
        this.y = y;
        this.rad = rad;
        this.updateBox();
    }

    private void updateBox() {
        this.box.set(this.x - this.rad, this.y - this.rad, this.rad * 2.0f, this.rad * 2.0f);
    }

    public AABox getBoundingBox() {
        return this.box;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getRadius() {
        return this.rad;
    }

    public void setX(float x) {
        this.x = x;
        this.updateBox();
    }

    public void setY(float y) {
        this.y = y;
        this.updateBox();
    }

    public void setRadius(float rad) {
        if (this.rad != rad) {
            this.rad = rad;
            this.updateBox();
        }
    }

    public void collides(float vx, float vy, Shape other, boolean fix, CollisionResult result) {
        if (other instanceof AABox) {
            this.collides(vx, vy, (AABox)other, fix, result);
            return;
        }
        if (other instanceof Circle) {
            this.collides(vx, vy, (Circle)other, fix, result);
            return;
        }
        if (other instanceof Capsule) {
            CircleCapsuleCollision.collides(vx, vy, this, (Capsule)other, fix, result);
            return;
        }
        result.missed();
    }

    public void collides(float vx, float vy, Circle mover, boolean fix, CollisionResult result) {
        CircleCircleCollision.collides(vx, vy, this, mover, fix, result);
    }

    public void collides(float vx, float vy, AABox mover, boolean fix, CollisionResult result) {
        AABoxCircleCollision.collides(vx, vy, this, mover, fix, result);
    }

    public boolean inside(float x, float y) {
        float dx = x - this.x;
        float dy = y - this.y;
        float disSq = dx * dx + dy * dy;
        return disSq < this.rad * this.rad;
    }

    public Circle copy() {
        return new Circle(this.x, this.y, this.rad);
    }

    public String toString() {
        return "[Circle " + this.x + "," + this.y + "  " + this.rad + "]";
    }
}

