/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt.geom;

import org.newdawn.render.util.Tuple2;
import org.newdawn.tilt.geom.Circle;
import org.newdawn.tilt.geom.CollisionResult;
import org.newdawn.tilt.geom.Line;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.geom.collide.CircleCapsuleCollision;

public class Capsule
extends Shape {
    private float radius;
    private Line line;
    private Tuple2 p1;
    private Tuple2 p2;
    private Tuple2 temp = new Tuple2(0.0f, 0.0f);

    public Capsule(Tuple2 p1, Tuple2 p2, float radius) {
        this.line = new Line(p1, p2);
        this.radius = radius;
        this.p1 = p1;
        this.p2 = p2;
    }

    public Line getLine() {
        return this.line;
    }

    public float getRadius() {
        return this.radius;
    }

    public void collides(float vx, float vy, Shape other, boolean fix, CollisionResult result) {
        if (other instanceof Circle) {
            CircleCapsuleCollision.collides(vx, vy, this, (Circle)other, fix, result);
            return;
        }
        result.missed();
    }

    public void setX(float x) {
        float dx = x - this.p1.x;
        this.p1.x += dx;
        this.p2.x += dx;
    }

    public void setY(float y) {
        float dy = y - this.p1.y;
        this.p1.y += dy;
        this.p2.y += dy;
    }

    public boolean inside(float x, float y) {
        this.temp.x = x;
        this.temp.y = y;
        return this.line.distanceSquared(this.temp) <= this.radius * this.radius;
    }

    public float getX() {
        return this.p1.x;
    }

    public float getY() {
        return this.p1.y;
    }
}

