/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt.geom;

import org.newdawn.tilt.geom.Circle;
import org.newdawn.tilt.geom.CollisionResult;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.geom.collide.AABoxAABoxCollision;
import org.newdawn.tilt.geom.collide.AABoxCircleCollision;

public class AABox
extends Shape {
    private float x;
    private float y;
    private float width;
    private float height;

    public AABox(float x, float y, float width, float height) {
        this.set(x, y, width, height);
    }

    public void set(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getX2() {
        return this.x + this.width;
    }

    public float getY2() {
        return this.y + this.height;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public void collides(float vx, float vy, Shape other, boolean fix, CollisionResult result) {
        if (other instanceof AABox) {
            this.collides(vx, vy, (AABox)other, fix, result);
            return;
        }
        if (other instanceof Circle) {
            this.collides(vx, vy, (Circle)other, fix, result);
            return;
        }
        result.missed();
    }

    public void collides(float vx, float vy, Circle mover, boolean fix, CollisionResult result) {
        AABoxCircleCollision.collides(vx, vy, this, mover, fix, result);
    }

    public void collides(float vx, float vy, AABox mover, boolean fix, CollisionResult result) {
        AABoxAABoxCollision.collides(vx, vy, this, mover, fix, result);
    }

    public boolean inside(float x, float y) {
        boolean xhit = x >= this.x && x <= this.x + this.width;
        boolean yhit = y >= this.y && y <= this.y + this.height;
        return xhit && yhit;
    }

    public AABox copy() {
        return new AABox(this.x, this.y, this.width, this.height);
    }

    public String toString() {
        return "[Box " + this.x + "," + this.y + " " + this.width + "," + this.height + "]";
    }
}

