/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt.effect;

import org.newdawn.render.particles.ParticleEngine;
import org.newdawn.tilt.effect.ParticleEffect;
import org.newdawn.tilt.effect.ParticleProvider;
import org.newdawn.tilt.effect.Position;
import org.newdawn.tilt.util.FastTrig;

public class TrailParticleEffect
implements ParticleEffect {
    private int countDown;
    private int x;
    private int z;
    private Position entity;
    private float next;

    public TrailParticleEffect(Position entity) {
        this.entity = entity;
        this.x = entity.getX();
        this.z = entity.getY();
    }

    public void update(ParticleProvider provider, ParticleEngine engine, int delta) {
        if (this.entity.done()) {
            return;
        }
        this.countDown -= delta;
        while (this.countDown < 0) {
            this.countDown += 5;
            int index = provider.getParticle(this, 1000);
            if (index == -1) continue;
            engine.setSize(index, 0.1f);
            engine.setPos(index, (float)this.x + 0.5f + (float)(FastTrig.cos(this.next) * (double)0.2f), (float)this.entity.getY(), (float)this.z + 0.5f + (float)(FastTrig.sin(this.next) * (double)0.2f));
            engine.setVelocity(index, 0.0f, (float)(Math.random() * 0.5), 0.0f);
            this.next += 0.4f;
        }
    }

    public void updateParticle(int index, int delta, ParticleEngine engine, int life) {
        float l = (float)life + (float)(Math.random() * 20.0);
        engine.setColor(index, 1.0f, 0.0f, 1.0f, l / 1000.0f);
    }

    public boolean finished() {
        return false;
    }
}

