/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt.effect;

import org.newdawn.render.particles.ParticleEngine;
import org.newdawn.tilt.effect.ParticleEffect;
import org.newdawn.tilt.effect.ParticleProvider;
import org.newdawn.tilt.util.FastTrig;

public class SplashParticleEffect
implements ParticleEffect {
    private float x;
    private float z;
    private boolean first = true;
    private int countDown = 1200;

    public SplashParticleEffect(int x, int z) {
        this.x = (float)x + 0.5f;
        this.z = (float)z + 0.5f;
    }

    public void update(ParticleProvider provider, ParticleEngine engine, int delta) {
        if (this.first) {
            this.first = false;
            int count = 12;
            float step = (float)(Math.PI * 2 / (double)count);
            for (int i = 0; i < count; ++i) {
                float zo;
                float xo;
                int index = provider.getParticle(this, 1000);
                if (index != -1) {
                    engine.setSize(index, (float)(Math.random() * (double)0.15f + (double)0.2f));
                    xo = (float)(FastTrig.cos((float)i * step) * (double)0.3f + Math.random() * (double)0.1f);
                    zo = (float)(FastTrig.sin((float)i * step) * (double)0.3f + Math.random() * (double)0.1f);
                    engine.setPos(index, this.x + xo, 0.0f, this.z + zo);
                    engine.setVelocity(index, xo, 3.0f + (float)(Math.random() * (double)0.2f), zo);
                }
                if ((index = provider.getParticle(this, 1000)) == -1) continue;
                engine.setSize(index, (float)(Math.random() * (double)0.15f + (double)0.2f));
                xo = (float)(FastTrig.cos((float)i * step) * (double)0.2f + Math.random() * (double)0.1f);
                zo = (float)(FastTrig.sin((float)i * step) * (double)0.2f + Math.random() * (double)0.1f);
                engine.setPos(index, this.x + xo, 0.0f, this.z + zo);
                engine.setVelocity(index, xo, 3.4f + (float)(Math.random() * (double)0.3f), zo);
            }
        }
        this.countDown -= delta;
    }

    public void updateParticle(int index, int delta, ParticleEngine engine, int life) {
        float l = (float)life + (float)(Math.random() * 100.0);
        engine.setColor(index, 0.2f, 0.0f, 0.0f, l / 1000.0f);
        engine.adjustVelocity(index, 0.0f, -0.009f * (float)delta, 0.0f);
        engine.adjustSize(index, -1.0E-5f * (float)delta);
    }

    public boolean finished() {
        return this.countDown < 0;
    }
}

