/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt.effect;

import org.newdawn.render.particles.ParticleEngine;
import org.newdawn.tilt.effect.ParticleEffect;
import org.newdawn.tilt.effect.ParticleProvider;
import org.newdawn.tilt.util.FastTrig;

public class SpiralParticleEffect
implements ParticleEffect {
    private int countDown;
    private int x;
    private int z;
    private float next;

    public SpiralParticleEffect(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public void update(ParticleProvider provider, ParticleEngine engine, int delta) {
        this.countDown -= delta;
        if (this.countDown < 0) {
            this.countDown = 40;
            int index = provider.getParticle(this, 3000);
            if (index != -1) {
                engine.setSize(index, 0.2f);
                float xp = (float)FastTrig.cos(this.next) * 0.3f;
                float zp = (float)FastTrig.sin(this.next) * 0.3f;
                engine.setPos(index, (float)this.x + 0.5f + xp, 0.0f, (float)this.z + 0.5f + zp);
                engine.setVelocity(index, 0.0f, 0.0f, 0.0f);
                this.next += 0.6f;
            }
        }
    }

    public void updateParticle(int index, int delta, ParticleEngine engine, int life) {
        engine.setColor(index, 1.0f, 1.0f, 0.0f, engine.getLife(index) / 3000.0f);
        engine.setVelocity(index, 0.0f, 1.0f - engine.getLife(index) * 3.0E-4f, 0.0f);
    }

    public boolean finished() {
        return false;
    }
}

