/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt.effect;

import org.newdawn.render.particles.ParticleEngine;
import org.newdawn.tilt.effect.ParticleEffect;
import org.newdawn.tilt.effect.ParticleProvider;

public class SmokeParticleEffect
implements ParticleEffect {
    private int countDown;
    private int x;
    private int z;

    public SmokeParticleEffect(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public void update(ParticleProvider provider, ParticleEngine engine, int delta) {
        this.countDown -= delta;
        if (this.countDown < 0) {
            this.countDown = 200;
            int index = provider.getParticle(this, 3000);
            if (index != -1) {
                engine.setSize(index, 0.15f + (float)(Math.random() * (double)0.2f));
                float xp = (float)(Math.random() * 0.1 - (double)0.05f);
                float zp = (float)(Math.random() * 0.1 - (double)0.05f);
                engine.setPos(index, (float)this.x + 0.5f + xp, 0.25f, (float)this.z + 0.5f + zp);
                float vx = (float)(Math.random() * 0.2 - (double)0.1f);
                float vz = (float)(Math.random() * 0.3 + (double)0.2f);
                float vy = (float)(Math.random() * 0.2 - (double)0.1f);
                engine.setVelocity(index, vx, vy, vz);
            }
        }
    }

    public void updateParticle(int index, int delta, ParticleEngine engine, int life) {
        float l = (float)life + (float)(Math.random() * 20.0);
        engine.setColor(index, l / 100.0f, l / 3500.0f, 0.0f, engine.getLife(index) / 3000.0f);
    }

    public boolean finished() {
        return false;
    }
}

