/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.Block;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapElement;
import org.newdawn.tilt.geom.Circle;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;

public class WaitPad
extends MapElement {
    private static Texture texture;
    private Circle bounds;
    private float x;
    private float y;
    private Map map;
    private Body body;
    private boolean up = false;
    private Ball ball;
    private int lastUp;
    private ArrayList blocks = new ArrayList();

    public static void init() throws IOException {
        texture = TextureLoader.get().getTextureLinear("res/opener.tga");
    }

    public WaitPad(Map map, float x, float y) {
        this.bounds = new Circle(x, y, 0.3f);
        this.x = x;
        this.y = y;
        this.map = map;
        this.body = new Body(this.bounds);
    }

    public Body getBody() {
        return null;
    }

    public void createImpl() {
    }

    public void destroy() {
    }

    public Shape getShape() {
        return this.bounds;
    }

    public void renderImpl(int delta, boolean reflection) {
        if (reflection) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.x, (float)this.y, (float)0.01f);
        float size = 0.8f;
        GL11.glEnable((int)3042);
        texture.bind();
        GL11.glBegin((int)7);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)(-size), (float)(-size), (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)size, (float)(-size), (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)size, (float)size, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)(-size), (float)size, (float)0.0f);
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public void renderOtherImpl(int delta, boolean reflection) {
    }

    public void update(GlobalEmitter emitter, int delta, float boardRollX, float boardRollY) {
        this.lastUp -= delta;
        if (this.up) {
            float disx = Math.abs(this.ball.getX() - this.x);
            float disy = Math.abs(this.ball.getY() - this.y);
            if (disx > 0.8f || disy > 0.8f) {
                this.up = false;
                this.ball = null;
                this.map.getElements(Block.class, this.blocks);
                for (int i = 0; i < this.blocks.size(); ++i) {
                    Block block = (Block)this.blocks.get(i);
                    if (block.getType() != 5) continue;
                    block.setTargetZ(0.0f);
                }
            }
        }
    }

    public boolean hit(Ball ball, float depth) {
        if (this.lastUp < 0 && !this.up) {
            this.lastUp = 400;
            this.up = true;
            this.ball = ball;
            this.map.getElements(Block.class, this.blocks);
            for (int i = 0; i < this.blocks.size(); ++i) {
                Block block = (Block)this.blocks.get(i);
                if (block.getType() != 5) continue;
                block.setTargetZ(3.0f);
            }
        }
        return true;
    }

    public MapElement copy(Map map) {
        return new WaitPad(map, this.x, this.y);
    }
}

