/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.render.util.Color;
import org.newdawn.render.window.LWJGLWindow;
import org.newdawn.state.GameState;
import org.newdawn.state.StateBasedGame;
import org.newdawn.state.transitions.FadeInTransition;
import org.newdawn.state.transitions.FadeOutTransition;
import org.newdawn.state.transitions.Transition;
import org.newdawn.tilt.Configuration;
import org.newdawn.tilt.MouseOverArea;
import org.newdawn.tilt.MouseOverGroup;
import org.newdawn.tilt.SharedUI;
import org.newdawn.tilt.Tilt;
import org.newdawn.tilt.TiltController;
import org.newdawn.util.Log;

public class VideoSettingsState
implements GameState {
    public static final int ID = 22;
    private LWJGLWindow window;
    private Texture title;
    private Texture back;
    private Texture check;
    private Texture uncheck;
    private Texture res600;
    private Texture res700;
    private Texture res800;
    private Texture res1000;
    private Texture screenSize;
    private Texture fullscreen;
    private Texture antialias;
    private MouseOverArea backArea;
    private MouseOverArea res600Area;
    private MouseOverArea res700Area;
    private MouseOverArea res800Area;
    private MouseOverArea res1000Area;
    private MouseOverArea fullscreenArea;
    private MouseOverArea antialiasArea;
    private MouseOverGroup group;
    private int selected;
    private boolean isRes600;
    private boolean isRes700;
    private boolean isRes800;
    private boolean isRes1000;
    private boolean isAntiAlias;
    private boolean isFullscreen;
    private int tooBigMessage = 0;
    private String message = "";
    private boolean multisample;
    private Color gray = new Color(0.0f, 0.0f, 0.0f, 0.5f);

    public VideoSettingsState(LWJGLWindow window) {
        this.window = window;
    }

    private void renderRectangle(float x, float y, float width, float height) {
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)x, (float)y);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2f((float)x, (float)(y + height));
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2f((float)(x + width), (float)(y + height));
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2f((float)(x + width), (float)y);
        GL11.glEnd();
    }

    public void init(StateBasedGame game) throws IOException {
        this.title = TextureLoader.get().getTextureLinear("res/settings.tga");
        this.back = TextureLoader.get().getTextureLinear("res/backtomenu.tga");
        this.check = TextureLoader.get().getTextureLinear("res/check.tga");
        this.uncheck = TextureLoader.get().getTextureLinear("res/uncheck.tga");
        this.screenSize = TextureLoader.get().getTextureLinear("res/screensize.tga");
        this.res600 = TextureLoader.get().getTextureLinear("res/res600.tga");
        this.res700 = TextureLoader.get().getTextureLinear("res/res700.tga");
        this.res800 = TextureLoader.get().getTextureLinear("res/res800.tga");
        this.res1000 = TextureLoader.get().getTextureLinear("res/res1000.tga");
        this.fullscreen = TextureLoader.get().getTextureLinear("res/fullscreen.tga");
        this.antialias = TextureLoader.get().getTextureLinear("res/antialias.tga");
        this.backArea = new MouseOverArea(this.window, 200.0f, 540.0f, 200.0f, 50.0f);
        this.res600Area = new MouseOverArea(this.window, 370.0f, 130.0f, 70.0f, 50.0f);
        this.res700Area = new MouseOverArea(this.window, 370.0f, 190.0f, 70.0f, 50.0f);
        this.res800Area = new MouseOverArea(this.window, 370.0f, 250.0f, 70.0f, 50.0f);
        this.res1000Area = new MouseOverArea(this.window, 370.0f, 315.0f, 70.0f, 50.0f);
        this.fullscreenArea = new MouseOverArea(this.window, 370.0f, 375.0f, 70.0f, 50.0f);
        this.antialiasArea = new MouseOverArea(this.window, 370.0f, 455.0f, 70.0f, 50.0f);
        this.group = new MouseOverGroup("video");
        this.group.addArea(this.res600Area);
        this.group.addArea(this.res700Area);
        this.group.addArea(this.res800Area);
        this.group.addArea(this.res1000Area);
        this.group.addArea(this.fullscreenArea);
        this.group.addArea(this.antialiasArea);
        this.group.addArea(this.backArea);
    }

    public void reinit(StateBasedGame game) throws IOException {
    }

    public void render(StateBasedGame game, int delta) {
        this.window.enterOrtho(600, 600);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.title.bind();
        this.renderRectangle(184.0f, -15.0f, 256.0f, 128.0f);
        this.screenSize.bind();
        this.renderRectangle(210.0f, 80.0f, 256.0f, 64.0f);
        this.res600.bind();
        this.renderRectangle(160.0f, 145.0f, 256.0f, 64.0f);
        this.res700.bind();
        this.renderRectangle(160.0f, 205.0f, 256.0f, 64.0f);
        this.res800.bind();
        this.renderRectangle(160.0f, 265.0f, 256.0f, 64.0f);
        this.res1000.bind();
        this.renderRectangle(160.0f, 325.0f, 256.0f, 64.0f);
        this.fullscreen.bind();
        this.renderRectangle(140.0f, 375.0f, 256.0f, 128.0f);
        this.antialias.bind();
        this.renderRectangle(150.0f, 440.0f, 256.0f, 128.0f);
        if (this.isRes600) {
            this.check.bind();
        } else {
            this.uncheck.bind();
        }
        float col = 0.75f + this.res600Area.getValue();
        GL11.glColor3f((float)col, (float)col, (float)col);
        this.renderRectangle(350.0f, 130.0f, 128.0f, 64.0f);
        if (this.isRes700) {
            this.check.bind();
        } else {
            this.uncheck.bind();
        }
        col = 0.75f + this.res700Area.getValue();
        GL11.glColor3f((float)col, (float)col, (float)col);
        this.renderRectangle(350.0f, 190.0f, 128.0f, 64.0f);
        if (this.isRes800) {
            this.check.bind();
        } else {
            this.uncheck.bind();
        }
        col = 0.75f + this.res800Area.getValue();
        GL11.glColor3f((float)col, (float)col, (float)col);
        this.renderRectangle(350.0f, 250.0f, 128.0f, 64.0f);
        if (this.isRes1000) {
            this.check.bind();
        } else {
            this.uncheck.bind();
        }
        col = 0.75f + this.res1000Area.getValue();
        GL11.glColor3f((float)col, (float)col, (float)col);
        this.renderRectangle(350.0f, 310.0f, 128.0f, 64.0f);
        if (this.isFullscreen) {
            this.check.bind();
        } else {
            this.uncheck.bind();
        }
        col = 0.75f + this.fullscreenArea.getValue();
        GL11.glColor3f((float)col, (float)col, (float)col);
        this.renderRectangle(350.0f, 370.0f, 128.0f, 64.0f);
        if (this.isAntiAlias) {
            this.check.bind();
        } else {
            this.uncheck.bind();
        }
        col = 0.75f + this.antialiasArea.getValue();
        GL11.glColor3f((float)col, (float)col, (float)col);
        this.renderRectangle(350.0f, 450.0f, 128.0f, 64.0f);
        col = 0.75f + this.backArea.getValue();
        GL11.glColor3f((float)col, (float)col, (float)col);
        this.back.bind();
        this.renderRectangle(174.0f, 540.0f, 256.0f, 64.0f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.tooBigMessage > 0) {
            this.drawString(520, this.message);
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        this.window.leaveOrtho();
    }

    private void drawString(int y, String text) {
        int x = (600 - SharedUI.smallFontO.getWidth(text)) / 2;
        SharedUI.smallFontO.drawString(x + 3, y + 3, text, this.gray);
        SharedUI.smallFontO.drawString(x, y, text, Color.white);
    }

    public void update(StateBasedGame game, int delta) {
        this.isFullscreen = Display.isFullscreen();
        if (this.tooBigMessage > 0) {
            this.tooBigMessage -= delta;
        }
        int oldSelected = this.selected;
        this.selected = 0;
        if (this.backArea.considerMouse(delta)) {
            this.selected = 1;
        }
        if (this.res600Area.considerMouse(delta)) {
            this.selected = 2;
        }
        if (this.res700Area.considerMouse(delta)) {
            this.selected = 3;
            if (700 > Tilt.originalHeight || 700 > Tilt.originalWidth) {
                this.res700Area.clear();
            }
        }
        if (this.res800Area.considerMouse(delta)) {
            this.selected = 4;
            if (800 > Tilt.originalHeight || 800 > Tilt.originalWidth) {
                this.res800Area.clear();
            }
        }
        if (this.res1000Area.considerMouse(delta)) {
            this.selected = 5;
            if (1000 > Tilt.originalHeight || 1000 > Tilt.originalWidth) {
                this.res1000Area.clear();
            }
        }
        if (this.fullscreenArea.considerMouse(delta)) {
            this.selected = 8;
        }
        if (this.antialiasArea.considerMouse(delta)) {
            this.selected = 6;
            if (!this.multisample) {
                this.antialiasArea.clear();
            }
        }
        if (oldSelected != this.selected && this.selected != 0) {
            SharedUI.playOver();
        }
        this.group.update();
        if (TiltController.buttonPressed()) {
            this.selectOption(game);
        }
        while (Mouse.next()) {
            if (Mouse.getEventButton() < 0 || !Mouse.getEventButtonState()) continue;
            this.selectOption(game);
        }
    }

    private void selectOption(StateBasedGame game) {
        if (this.selected == 1) {
            SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
            game.changeToState(7, (Transition)new FadeOutTransition(Color.white), (Transition)new FadeInTransition(Color.white));
            return;
        }
        if (this.selected == 2) {
            SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
            this.tryRes(600);
        }
        if (this.selected == 3) {
            SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
            this.tryRes(700);
        }
        if (this.selected == 4) {
            SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
            this.tryRes(800);
        }
        if (this.selected == 5) {
            SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
            this.tryRes(1000);
        }
        if (this.selected == 6) {
            if (!this.multisample) {
                SharedUI.dud.playAsSoundEffect(1.0f, 1.0f);
                this.tooBigMessage = 1000;
                this.message = "No Hardware Smoothing Detected";
                return;
            }
            if (!this.isAntiAlias) {
                SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
                Configuration.setGlobalValue("antialias", 1.0f);
                this.isAntiAlias = true;
            } else {
                SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
                Configuration.setGlobalValue("antialias", 0.0f);
                this.isAntiAlias = false;
            }
        }
        if (this.selected == 8) {
            SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
            this.isFullscreen = !this.isFullscreen;
            Tilt.toggleFullscreen();
        }
    }

    private void tryRes(int size) {
        if (size == this.window.getWidth()) {
            return;
        }
        if (size > Tilt.originalHeight || size > Tilt.originalWidth) {
            SharedUI.dud.playAsSoundEffect(1.0f, 1.0f);
            this.message = "Screen size isn't big enough";
            this.tooBigMessage = 1000;
            return;
        }
        try {
            if (this.isFullscreen) {
                Tilt.toggleFullscreen();
            }
            Display.setDisplayMode((DisplayMode)new DisplayMode(size, size));
            this.window.setWidth(size);
            this.window.setHeight(size);
            Tilt.configureDisplay(size, size);
            Configuration.setGlobalValue("screensize", size);
            this.isRes600 = size == 600;
            this.isRes700 = size == 700;
            this.isRes800 = size == 800;
            this.isRes1000 = size == 1000;
            this.isFullscreen = false;
        }
        catch (LWJGLException e) {
            Log.log((Throwable)e);
        }
    }

    public void enterState(StateBasedGame game) {
        Mouse.setGrabbed((boolean)false);
        this.multisample = GLContext.getCapabilities().GL_ARB_multisample;
        float size = Configuration.getGlobalValue("screensize", 600.0f);
        this.isRes600 = size == 600.0f;
        this.isRes700 = size == 700.0f;
        this.isRes800 = size == 800.0f;
        this.isRes1000 = size == 1000.0f;
        this.isAntiAlias = Configuration.getGlobalValue("antialias", 0.0f) != 0.0f;
        this.isFullscreen = Display.isFullscreen();
        this.group.reset();
    }

    public void leaveState(StateBasedGame game) {
    }
}

