/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.sound.Sound;
import org.newdawn.sound.SoundStore;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.Block;
import org.newdawn.tilt.Floor;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapElement;
import org.newdawn.tilt.geom.AABox;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;
import org.newdawn.util.Log;

public class Tube
extends Floor {
    private static Sound noise;
    private static Texture texture;
    private AABox box;
    private float h;
    private int top;
    private float xp;
    private float yp;
    private boolean horizontal;
    private Map map;
    private float x;
    private float y;
    private float width;
    private float height;
    private String id;

    public static void init() throws IOException {
        noise = SoundStore.get().getOgg("res/sounds/teleport.ogg");
        texture = TextureLoader.get().getTextureLinear("res/tube.tga");
    }

    public Tube(String id, Map map, float x, float y, float width, float height, float h) throws IOException {
        super(id);
        if (width > height) {
            this.horizontal = true;
            height = 1.0f;
        } else {
            width = 1.0f;
        }
        this.id = id;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.map = map;
        this.box = new AABox(x, y, width, height);
        this.h = -h;
        this.xp = x + width / 2.0f;
        this.yp = y + height / 2.0f;
    }

    public Body getBody() {
        return null;
    }

    public void createImpl() {
        try {
            if (this.horizontal) {
                this.map.addItem(new Block(this.map, this.x, this.y - 0.1f, this.width, 0.1f, 0.05f, 6, false));
                this.map.addItem(new Block(this.map, this.x, this.y + this.height, this.width, 0.1f, 0.05f, 6, false));
            } else {
                this.map.addItem(new Block(this.map, this.x - 0.1f, this.y, 0.1f, this.height, 0.05f, 6, false));
                this.map.addItem(new Block(this.map, this.x + this.width, this.y, 0.1f, this.height, 0.05f, 6, false));
            }
        }
        catch (IOException e) {
            Log.log((Throwable)e);
        }
        this.top = GL11.glGenLists((int)1);
        GL11.glNewList((int)this.top, (int)4864);
        if (this.horizontal) {
            this.renderHorizontal();
        } else {
            this.renderVertical();
        }
        GL11.glEndList();
    }

    public void destroy() {
        GL11.glDeleteLists((int)this.top, (int)1);
    }

    public Shape getShape() {
        return this.box;
    }

    public void renderHorizontal() {
        float scale;
        float dodge = 0.0f;
        float scale2 = scale = 1.0f;
        int segments = 10;
        float size = 0.6f;
        GL11.glBegin((int)7);
        float x1 = -(this.box.getWidth() / 2.0f);
        float x2 = this.box.getWidth() / 2.0f;
        for (int i = 0; i < segments; ++i) {
            float ang1 = (float)(Math.PI + (double)i * (Math.PI * 2 / (double)segments));
            float ang2 = (float)(Math.PI + (double)(i + 1) * (Math.PI * 2 / (double)segments));
            float y1 = (float)Math.cos(ang1) * size;
            float z1 = (float)Math.sin(ang1) * size;
            float y2 = (float)Math.cos(ang2) * size;
            float z2 = (float)Math.sin(ang2) * size;
            float ts = (float)i * (1.0f / (float)segments);
            float te = (float)(i + 1) * (1.0f / (float)segments);
            GL11.glTexCoord2f((float)0.0f, (float)ts);
            GL11.glVertex3f((float)x1, (float)y1, (float)z1);
            GL11.glTexCoord2f((float)(this.box.getWidth() * scale), (float)ts);
            GL11.glVertex3f((float)x2, (float)y1, (float)z1);
            GL11.glTexCoord2f((float)(this.box.getWidth() * scale), (float)te);
            GL11.glVertex3f((float)x2, (float)y2, (float)z2);
            GL11.glTexCoord2f((float)0.0f, (float)te);
            GL11.glVertex3f((float)x1, (float)y2, (float)z2);
        }
        GL11.glEnd();
    }

    public void renderVertical() {
        float scale;
        float dodge = 0.0f;
        float scale2 = scale = 1.0f;
        int segments = 10;
        float size = 0.6f;
        GL11.glBegin((int)7);
        float y1 = -(this.box.getHeight() / 2.0f);
        float y2 = this.box.getHeight() / 2.0f;
        for (int i = 0; i < segments; ++i) {
            float ang1 = (float)(Math.PI + (double)i * (Math.PI * 2 / (double)segments));
            float ang2 = (float)(Math.PI + (double)(i + 1) * (Math.PI * 2 / (double)segments));
            float x1 = (float)Math.cos(ang1) * size;
            float z1 = (float)Math.sin(ang1) * size;
            float x2 = (float)Math.cos(ang2) * size;
            float z2 = (float)Math.sin(ang2) * size;
            float ts = (float)i * (1.0f / (float)segments);
            float te = (float)(i + 1) * (1.0f / (float)segments);
            GL11.glTexCoord2f((float)0.0f, (float)ts);
            GL11.glVertex3f((float)x1, (float)y1, (float)z1);
            GL11.glTexCoord2f((float)(this.box.getHeight() * scale), (float)ts);
            GL11.glVertex3f((float)x1, (float)y2, (float)z1);
            GL11.glTexCoord2f((float)(this.box.getHeight() * scale), (float)te);
            GL11.glVertex3f((float)x2, (float)y2, (float)z2);
            GL11.glTexCoord2f((float)0.0f, (float)te);
            GL11.glVertex3f((float)x2, (float)y1, (float)z2);
        }
        GL11.glEnd();
    }

    public void renderImpl(int delta, boolean reflection) {
    }

    public void renderOtherImpl(int delta, boolean reflection) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2884);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)1.0f, (float)0.3f);
        GL11.glMatrixMode((int)5888);
        GL11.glTranslatef((float)this.xp, (float)this.yp, (float)0.6f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
        texture.bind();
        GL11.glCallList((int)this.top);
        GL11.glMatrixMode((int)5888);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
    }

    public void update(GlobalEmitter emitter, int delta, float boardRollX, float boardRollY) {
    }

    public boolean hit(Ball other, float depth) {
        if (other != null && other.isDead()) {
            return true;
        }
        return true;
    }

    public MapElement copy(Map map) {
        try {
            return new Tube(this.id, map, this.box.getX(), this.box.getY(), this.box.getWidth(), this.box.getHeight(), -this.h);
        }
        catch (IOException e) {
            Log.log((Throwable)e);
            return null;
        }
    }
}

