/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.sound.Sound;
import org.newdawn.sound.SoundStore;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.Block;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapElement;
import org.newdawn.tilt.geom.Circle;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;

public class ToggleSwitch
extends MapElement {
    private static Texture blueOff;
    private static Texture blueOn;
    private static Texture redOff;
    private static Texture redOn;
    private static Texture particle;
    private static Sound collect;
    public static int RED;
    public static int BLUE;
    private Texture texture;
    private Texture textureOff;
    private Texture textureOn;
    private Circle bounds;
    private float x;
    private float y;
    private Map map;
    private Body body;
    private Ball ball;
    private int lastUp;
    private int type;
    private String id;
    private boolean state;
    private boolean clear = true;
    private ArrayList switchs = new ArrayList();
    private ArrayList blocks = new ArrayList();

    public static void init() throws IOException {
        blueOff = TextureLoader.get().getTextureLinear("res/blueswitch.tga");
        blueOn = TextureLoader.get().getTextureLinear("res/blueswitch-on.tga");
        redOff = TextureLoader.get().getTextureLinear("res/redswitch.tga");
        redOn = TextureLoader.get().getTextureLinear("res/redswitch-on.tga");
        particle = TextureLoader.get().getTextureLinear("res/particle1.tga");
        collect = SoundStore.get().getOgg("res/sounds/collect.ogg");
    }

    public ToggleSwitch(Map map, float x, float y, String id) {
        this.bounds = new Circle(x, y, 0.2f);
        this.x = x;
        this.y = y;
        this.id = id;
        this.map = map;
        this.type = BLUE;
        if (id.indexOf("red") >= 0) {
            this.type = RED;
        }
        if (id.indexOf("on") >= 0) {
            this.state = true;
        }
        this.body = new Body(this.bounds);
        this.textureOn = blueOn;
        this.textureOff = blueOff;
        if (this.type == RED) {
            this.textureOn = redOn;
            this.textureOff = redOff;
        }
        this.texture = this.state ? this.textureOn : this.textureOff;
    }

    public Body getBody() {
        return null;
    }

    public void createImpl() {
    }

    public void destroy() {
    }

    public Shape getShape() {
        return this.bounds;
    }

    public void renderImpl(int delta, boolean reflection) {
        if (reflection) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.x, (float)this.y, (float)0.01f);
        float size = 0.5f;
        float size2 = size + 0.1f;
        float z = 0.02f;
        float z2 = 0.1f;
        GL11.glEnable((int)3042);
        this.texture.bind();
        GL11.glBegin((int)7);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)(-size), (float)(-size), (float)z);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)size, (float)(-size), (float)z);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)size, (float)size, (float)z);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)(-size), (float)size, (float)z);
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GL11.glPopMatrix();
    }

    public void renderOtherImpl(int delta, boolean reflection) {
        if (reflection) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.x, (float)this.y, (float)0.01f);
        float size = 0.5f;
        float size2 = size + 0.1f;
        float z = 0.02f;
        float z2 = 0.2f;
        GL11.glEnable((int)3042);
        if (this.state) {
            particle.bind();
            if (this.type == RED) {
                GL11.glColor4f((float)1.0f, (float)0.5f, (float)0.5f, (float)1.0f);
            } else {
                GL11.glColor4f((float)0.5f, (float)0.5f, (float)1.0f, (float)1.0f);
            }
            GL11.glBegin((int)7);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(-size2), (float)(-size2), (float)z2);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)size2, (float)(-size2), (float)z2);
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)size2, (float)size2, (float)z2);
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)(-size2), (float)size2, (float)z2);
            GL11.glEnd();
        }
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GL11.glPopMatrix();
    }

    public void update(GlobalEmitter emitter, int delta, float boardRollX, float boardRollY) {
        this.lastUp -= delta;
        if (!this.clear) {
            float disx = Math.abs(this.ball.getX() - this.x);
            float disy = Math.abs(this.ball.getY() - this.y);
            if (disx > 0.6f || disy > 0.6f) {
                this.clear = true;
            }
        }
    }

    public boolean hit(Ball ball, float depth) {
        if (this.lastUp < 0 && this.clear) {
            int i;
            this.lastUp = 400;
            this.clear = false;
            this.state = !this.state;
            this.ball = ball;
            this.texture = this.state ? this.textureOn : this.textureOff;
            collect.playAsSoundEffect(0.5f, 0.6f);
            boolean allOn = true;
            this.map.getElements(ToggleSwitch.class, this.switchs);
            for (i = 0; i < this.switchs.size(); ++i) {
                ToggleSwitch toggle = (ToggleSwitch)this.switchs.get(i);
                if (toggle.type != this.type) continue;
                allOn &= toggle.state;
            }
            this.map.getElements(Block.class, this.blocks);
            for (i = 0; i < this.blocks.size(); ++i) {
                Block block = (Block)this.blocks.get(i);
                if (block.getType() != this.type) continue;
                block.setTargetZ(allOn ? 2.0f : 0.0f);
            }
            if (allOn) {
                collect.playAsSoundEffect(2.0f, 1.0f);
            }
        }
        return true;
    }

    public MapElement copy(Map map) {
        return new ToggleSwitch(map, this.x, this.y, this.id);
    }

    static {
        RED = 3;
        BLUE = 4;
    }
}

