/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import org.lwjgl.opengl.GL11;
import org.newdawn.glui.font.BitmapFont;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.util.Color;
import org.newdawn.render.window.LWJGLWindow;
import org.newdawn.state.StateBasedGame;
import org.newdawn.state.loading.LoadingClient;
import org.newdawn.state.loading.LoadingGameState;
import org.newdawn.state.loading.LoadingList;
import org.newdawn.tilt.Tilt;

public class TiltLoadingState
extends LoadingGameState {
    public static final int ID = 101;
    private BitmapFont font;

    public TiltLoadingState(LWJGLWindow window, Tilt tilt) {
        super(window, (LoadingClient)tilt);
    }

    public void init(StateBasedGame game) throws IOException {
        super.init(game);
        this.font = new BitmapFont("res/new16.tga");
    }

    private void renderRectangle(float x, float y, float width, float height) {
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)x, (float)y);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2f((float)x, (float)(y + height));
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2f((float)(x + width), (float)(y + height));
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2f((float)(x + width), (float)y);
        GL11.glEnd();
    }

    public void render(StateBasedGame game, int delta) {
        super.render(game, delta);
        this.window.enterOrtho(600, 600);
        int xp = (this.window.getWidth() - 600) / 2;
        int yp = (this.window.getHeight() - 600) / 2;
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        Texture.bindNone();
        this.renderRectangle(-xp, -yp, 600 + xp * 2, 600 + yp * 2);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3553);
        String message = "Loading...";
        int x = (600 - this.font.getWidth(message)) / 2;
        this.font.drawString(x, 270, message, Color.black);
        Texture.bindNone();
        GL11.glColor3f((float)0.5f, (float)0.5f, (float)0.5f);
        this.renderRectangle(98.0f, 278.0f, 404.0f, 24.0f);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        this.renderRectangle(99.0f, 279.0f, 402.0f, 22.0f);
        GL11.glColor3f((float)0.5f, (float)0.5f, (float)0.5f);
        this.renderRectangle(100.0f, 280.0f, 400.0f, 20.0f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.renderRectangle(101.0f, 281.0f, 398.0f, 18.0f);
        float comp = (float)LoadingList.getLeft() / (float)LoadingList.getTotal();
        comp = 1.0f - comp;
        GL11.glColor3f((float)1.0f, (float)0.5f, (float)0.0f);
        this.renderRectangle(102.0f, 282.0f, 396.0f * comp, 16.0f);
        this.window.leaveOrtho();
    }
}

