/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import org.lwjgl.input.Controller;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Keyboard;
import org.newdawn.tilt.Configuration;
import org.newdawn.util.Log;

public class TiltController {
    public static boolean ALL;
    private static boolean enabled;
    private static boolean works;
    private static Controller controller;
    private static boolean buttonPressed;
    private static int xIndex;
    private static int yIndex;
    private float[] values = new float[100];
    private static boolean analogue;
    private static boolean up;
    private static boolean down;
    private static boolean left;
    private static boolean right;
    private static float posX;
    private static float negX;
    private static float posY;
    private static float negY;
    private static boolean keyboard;

    public static void init() {
        try {
            keyboard = true;
            analogue = false;
            enabled = false;
            Controllers.create();
            if (Controllers.getControllerCount() == 0) {
                works = false;
                Log.log((String)"No controllers connected/detected");
            } else {
                works = true;
                for (int i = 0; i < Controllers.getControllerCount(); ++i) {
                    if (Controllers.getController((int)i).getAxisCount() <= 0) continue;
                    controller = Controllers.getController((int)i);
                    break;
                }
                if (controller != null) {
                    Log.log((String)("Controller: " + controller.getName() + " : " + controller.getButtonCount() + " : " + controller.getAxisCount()));
                    enabled = Configuration.getGlobalValue("gamepad", 0.0f) != 0.0f;
                    xIndex = (int)Configuration.getGlobalValue("xaxis", 1.0f);
                    yIndex = (int)Configuration.getGlobalValue("yaxis", 0.0f);
                } else {
                    enabled = false;
                    works = false;
                    Log.log((String)"No valid controllers found");
                }
            }
        }
        catch (Throwable e) {
            works = false;
            Log.log((Throwable)e);
        }
    }

    public static boolean isWorking() {
        return works;
    }

    public static void setEnabled(boolean e) {
        enabled = e;
        keyboard = !enabled;
    }

    public static boolean isEnabled() {
        if (keyboard) {
            return true;
        }
        return works && enabled;
    }

    public static void setXAxisIndex(int index) {
        xIndex = index;
    }

    public static void setYAxisIndex(int index) {
        yIndex = index;
    }

    public static int getXAxisIndex() {
        return xIndex;
    }

    public static int getYAxisIndex() {
        return yIndex;
    }

    public static boolean isKeyboard() {
        return keyboard;
    }

    public static int checkForAxisActivity(int not) {
        analogue = false;
        for (int i = 0; i < controller.getAxisCount(); ++i) {
            if (i == not || !(Math.abs(controller.getAxisValue(i)) > 0.7f)) continue;
            return i;
        }
        return -1;
    }

    public static float getXAxis() {
        if (keyboard) {
            if (Keyboard.isKeyDown((int)203)) {
                return -1.0f;
            }
            if (Keyboard.isKeyDown((int)205)) {
                return 1.0f;
            }
            return 0.0f;
        }
        if (!works) {
            return 0.0f;
        }
        float value = controller.getAxisValue(xIndex);
        if (value < negX) {
            negX = value;
        }
        if (value > posX) {
            posX = value;
        }
        if (value < 0.0f) {
            value = Math.abs(value) / negX;
        }
        if (value > 0.0f) {
            value = Math.abs(value) / posX;
        }
        if (value < 0.9f && value > 0.1f) {
            analogue = true;
        }
        return value;
    }

    public static float getYAxis() {
        if (keyboard) {
            if (Keyboard.isKeyDown((int)200)) {
                return -1.0f;
            }
            if (Keyboard.isKeyDown((int)208)) {
                return 1.0f;
            }
            return 0.0f;
        }
        if (!works) {
            return 0.0f;
        }
        float value = controller.getAxisValue(yIndex);
        if (value < negY) {
            negY = value;
        }
        if (value > posY) {
            posY = value;
        }
        if (value < 0.0f) {
            value = Math.abs(value) / negY;
        }
        if (value > 0.0f) {
            value = Math.abs(value) / posY;
        }
        if (value < 0.9f && value > 0.1f) {
            analogue = true;
        }
        return value;
    }

    public static boolean leftPressed() {
        boolean ret;
        if (keyboard) {
            if (!left) {
                left = Keyboard.isKeyDown((int)203);
                return left;
            }
            if (left) {
                left = Keyboard.isKeyDown((int)203);
                return false;
            }
        }
        boolean bl = ret = TiltController.getXAxis() < -0.6f;
        if (!left && ret) {
            left = true;
            return true;
        }
        if (!ret) {
            left = false;
            return false;
        }
        return false;
    }

    public static boolean rightPressed() {
        boolean ret;
        if (keyboard) {
            if (!right) {
                right = Keyboard.isKeyDown((int)205);
                return right;
            }
            if (right) {
                right = Keyboard.isKeyDown((int)205);
                return false;
            }
        }
        boolean bl = ret = TiltController.getXAxis() > 0.6f;
        if (!right && ret) {
            right = true;
            return true;
        }
        if (!ret) {
            right = false;
            return false;
        }
        return false;
    }

    public static boolean upPressed() {
        boolean ret;
        if (keyboard) {
            if (!up) {
                up = Keyboard.isKeyDown((int)200);
                return up;
            }
            if (up) {
                up = Keyboard.isKeyDown((int)200);
                return false;
            }
        }
        boolean bl = ret = TiltController.getYAxis() < -0.6f;
        if (!up && ret) {
            up = true;
            return true;
        }
        if (!ret) {
            up = false;
            return false;
        }
        return false;
    }

    public static boolean downPressed() {
        boolean ret;
        if (keyboard) {
            if (!down) {
                down = Keyboard.isKeyDown((int)208);
                return down;
            }
            if (down) {
                down = Keyboard.isKeyDown((int)208);
                return false;
            }
        }
        boolean bl = ret = TiltController.getYAxis() > 0.6f;
        if (!down && ret) {
            down = true;
            return true;
        }
        if (!ret) {
            down = false;
            return false;
        }
        return false;
    }

    public static boolean isAnalgoue() {
        if (keyboard) {
            return false;
        }
        return analogue;
    }

    public static boolean buttonPressed() {
        if (keyboard) {
            if (!buttonPressed) {
                if (Keyboard.isKeyDown((int)28)) {
                    buttonPressed = true;
                    return true;
                }
                if (Keyboard.isKeyDown((int)57)) {
                    buttonPressed = true;
                    return true;
                }
            }
            buttonPressed = Keyboard.isKeyDown((int)28) || Keyboard.isKeyDown((int)57);
            return false;
        }
        if (!works) {
            return false;
        }
        if (buttonPressed) {
            for (int i = 0; i < controller.getButtonCount(); ++i) {
                if (!controller.isButtonPressed(i)) continue;
                return false;
            }
            buttonPressed = false;
            return false;
        }
        for (int i = 0; i < controller.getButtonCount(); ++i) {
            if (!controller.isButtonPressed(i)) continue;
            buttonPressed = true;
            return true;
        }
        buttonPressed = false;
        return false;
    }

    static {
        buttonPressed = false;
        xIndex = 1;
        yIndex = 0;
    }
}

