/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.input.Cursor;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.glu.GLU;
import org.newdawn.render.texture.CursorLoader;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.render.util.Color;
import org.newdawn.render.window.LWJGLWindow;
import org.newdawn.render.window.WindowListener;
import org.newdawn.sound.SoundStore;
import org.newdawn.state.GameState;
import org.newdawn.state.StateBasedGame;
import org.newdawn.state.loading.Loadable;
import org.newdawn.state.loading.LoadingClient;
import org.newdawn.state.transitions.FadeInTransition;
import org.newdawn.state.transitions.FadeOutTransition;
import org.newdawn.state.transitions.Transition;
import org.newdawn.tilt.AudioSettingsState;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.BestTimesState;
import org.newdawn.tilt.Block;
import org.newdawn.tilt.Bouncer;
import org.newdawn.tilt.Bridge;
import org.newdawn.tilt.Bumper;
import org.newdawn.tilt.CapsuleBlock;
import org.newdawn.tilt.Configuration;
import org.newdawn.tilt.ControlSettingsState;
import org.newdawn.tilt.CubitItem;
import org.newdawn.tilt.Cylinder;
import org.newdawn.tilt.EmptyState;
import org.newdawn.tilt.ExitItem;
import org.newdawn.tilt.FallingBridge;
import org.newdawn.tilt.Fan;
import org.newdawn.tilt.Fence;
import org.newdawn.tilt.Floor;
import org.newdawn.tilt.Fuggle;
import org.newdawn.tilt.GravityProducer;
import org.newdawn.tilt.InGameState;
import org.newdawn.tilt.LevelSelectState;
import org.newdawn.tilt.MapStore;
import org.newdawn.tilt.MenuState;
import org.newdawn.tilt.MovingBlock;
import org.newdawn.tilt.NagState;
import org.newdawn.tilt.OneWayTile;
import org.newdawn.tilt.Peg;
import org.newdawn.tilt.PowerPill;
import org.newdawn.tilt.RegisterState;
import org.newdawn.tilt.Roof;
import org.newdawn.tilt.SettingsState;
import org.newdawn.tilt.SharedUI;
import org.newdawn.tilt.ShrinkToken;
import org.newdawn.tilt.SpeedToken;
import org.newdawn.tilt.Spikes;
import org.newdawn.tilt.SplashState;
import org.newdawn.tilt.Stud;
import org.newdawn.tilt.Switch;
import org.newdawn.tilt.Teleport;
import org.newdawn.tilt.TiltController;
import org.newdawn.tilt.TiltLoadingState;
import org.newdawn.tilt.ToggleSwitch;
import org.newdawn.tilt.Tube;
import org.newdawn.tilt.VideoSettingsState;
import org.newdawn.tilt.WaitPad;
import org.newdawn.util.Log;

public class Tilt
extends StateBasedGame
implements WindowListener,
LoadingClient {
    public static int originalWidth;
    public static int originalHeight;
    private static Tilt game;
    private InGameState ingame;
    private MenuState menu;
    private LevelSelectState level;
    private RegisterState register;
    private LWJGLWindow window;
    private Texture[] backg = new Texture[5];
    private float rot;
    private int skyList;
    private long render;
    private long update;
    private int remainder;
    private int timeStep = 5;
    private int steps = 0;
    private long loopTime;
    private long lastHit;
    private boolean showFPS;
    private boolean f7down;
    private boolean f8down;
    private boolean f9down;
    private boolean fullscreen;
    private boolean framecap;
    private long lastMem;
    private int lastMemUpdate;
    private int lastFPS;
    private String memGap = "";
    private String fps = "";
    private String[] nums = new String[20000];
    private int startState = 8;

    public Tilt() {
        for (int i = 0; i < this.nums.length; ++i) {
            this.nums[i] = "" + i;
        }
        game = this;
        Log.log((String)"Starting Tiltilation");
        TiltController.init();
        try {
            originalWidth = Display.getDisplayMode().getWidth();
            originalHeight = Display.getDisplayMode().getHeight();
            if (Display.getDisplayMode().getBitsPerPixel() == 16) {
                Log.log((String)"16 Bit Mode Enabled");
                TextureLoader.get().set16BitMode();
            }
            int size = (int)Configuration.getGlobalValue("screensize", 600.0f);
            this.window = new LWJGLWindow("Tiltilation", (WindowListener)this, size, size, false);
            this.window.setClearBuffer(false);
            try {
                this.window.setIcon("res/icon.tga");
            }
            catch (IOException e) {
                Log.log((Throwable)e);
            }
            this.setWindow(this.window);
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
    }

    public void setStateState(int start) {
        this.startState = start;
    }

    public void startRendering() {
        if (this.window != null) {
            this.window.startRendering();
        }
    }

    public String getNumString(long i) {
        if (i < 0L) {
            return "NEG";
        }
        if (i >= (long)this.nums.length) {
            return "MAX";
        }
        return this.nums[(int)i];
    }

    public void init() {
        boolean isAntiAlias;
        String renderer = GL11.glGetString((int)7937);
        boolean multisample = false;
        boolean bl = isAntiAlias = Configuration.getGlobalValue("antialias", multisample ? 1.0f : 0.0f) != 0.0f;
        if (isAntiAlias) {
            Tilt.tryAntialias(this.window);
        }
        String vendor = GL11.glGetString((int)7936);
        String version = GL11.glGetString((int)7938);
        Log.log((String)"--------------------------------------------------------------------------");
        Log.log((String)("GL_VENDOR: " + vendor));
        Log.log((String)("GL_VERSION: " + version));
        Log.log((String)("GL_RENDERER: " + renderer));
        Log.log((String)("Display Mode: " + Display.getDisplayMode()));
        Log.log((String)("Driver Adapter: " + Display.getAdapter()));
        Log.log((String)("Driver Version: " + Display.getVersion()));
        Log.log((String)("LWJGL Version: " + Sys.getVersion()));
        Log.log((String)("Operating System: " + System.getProperty("os.name")));
        Log.log((String)("Operating System Version: " + System.getProperty("os.version")));
        Log.log((String)("Architecture: " + System.getProperty("os.arch")));
        Log.log((String)("Java Vendor: " + System.getProperty("java.vendor")));
        Log.log((String)("Java Version: " + System.getProperty("java.version")));
        Log.log((String)"--------------------------------------------------------------------------");
        boolean devMode = new File(".project").exists();
        Log.log((String)("Development Mode: " + devMode));
        Configuration.init();
        SoundStore.get().init();
        if (!devMode) {
            SoundStore.get().setDeferredLoading(true);
            TextureLoader.get().setDeferredLoading(true);
        }
        boolean musicOn = Configuration.getGlobalValue("musicon", 1.0f) == 1.0f;
        boolean soundOn = Configuration.getGlobalValue("soundon", 1.0f) == 1.0f;
        float musicVolume = Configuration.getGlobalValue("musicvolume", 0.5f);
        float soundVolume = Configuration.getGlobalValue("soundvolume", 1.0f);
        SoundStore.get().setMusicOn(musicOn);
        SoundStore.get().setSoundsOn(soundOn);
        SoundStore.get().setMusicVolume(musicVolume);
        SoundStore.get().setSoundVolume(soundVolume);
        this.lastHit = LWJGLWindow.getTime();
        try {
            try {
                Cursor cursor = CursorLoader.get().getCursor("res/cursor.tga", 3, 61);
                Mouse.setNativeCursor((Cursor)cursor);
            }
            catch (LWJGLException e) {
                Log.log((Throwable)e);
            }
            Ball.init();
            MapStore.init();
            SharedUI.init();
            Switch.init();
            Roof.init();
            Bumper.init();
            Bridge.init();
            FallingBridge.init();
            CubitItem.init();
            ShrinkToken.init();
            SpeedToken.init();
            ExitItem.init();
            Cylinder.init();
            Block.init();
            Teleport.init();
            MovingBlock.init();
            CapsuleBlock.init();
            Bouncer.init();
            Fence.init();
            Floor.init();
            GravityProducer.init();
            WaitPad.init();
            Peg.init();
            Spikes.init();
            Tube.init();
            ToggleSwitch.init();
            OneWayTile.init();
            Fuggle.init();
            Stud.init();
            PowerPill.init();
            Fan.init();
            TextureLoader.get().setDeferredLoading(false);
            this.backg[0] = TextureLoader.get().getTextureLinear("res/backg.tga");
            this.backg[1] = TextureLoader.get().getTextureLinear("res/backg2.tga");
            this.backg[2] = TextureLoader.get().getTextureLinear("res/backg3.tga");
            this.backg[3] = TextureLoader.get().getTextureLinear("res/backg4.tga");
            this.backg[4] = TextureLoader.get().getTextureLinear("res/backg5.tga");
            if (!devMode) {
                TextureLoader.get().setDeferredLoading(true);
                System.setOut(new PrintStream(new NullOutputStream()));
                System.setErr(new PrintStream(new NullOutputStream()));
            }
            this.buildSkyBox();
            Tilt.configureDisplay(this.window.getWidth(), this.window.getHeight());
            this.ingame = new InGameState(this.window);
            this.menu = new MenuState(this.window);
            this.level = new LevelSelectState(this.ingame, this.window);
            this.register = new RegisterState(this.window);
            if (Configuration.prefs.getString("webname", "").toLowerCase().indexOf("failed") >= 0) {
                Configuration.remove("r1");
                Configuration.remove("r2");
                Configuration.remove("r3");
            }
            this.addState(1, this.ingame);
            this.addState(2, this.menu);
            this.addState(100, new EmptyState(this.window));
            this.addState(101, (GameState)new TiltLoadingState(this.window, this));
            this.addState(10, new SplashState(this.window));
            this.addState(8, this.level);
            this.addState(67, this.register);
            this.addState(76, new BestTimesState(this.window));
            this.addState(7, new SettingsState(this.window));
            this.addState(21, new ControlSettingsState(this.window));
            this.addState(22, new VideoSettingsState(this.window));
            this.addState(23, new AudioSettingsState(this.window));
            this.addState(32, new NagState(this.window));
            if (devMode) {
                this.init(this.startState);
            } else {
                this.init(100);
            }
            if (Configuration.getGlobalValue("fullscreen", 0.0f) == 1.0f) {
                Tilt.toggleFullscreen();
            }
            this.framecap = Configuration.getGlobalValue("framecap", 1.0f) == 1.0f;
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
            System.exit(0);
        }
    }

    public InGameState getInGame() {
        return this.ingame;
    }

    public static void configureDisplay(int width, int height) {
        GL11.glViewport((int)0, (int)0, (int)width, (int)height);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GLU.gluPerspective((float)45.0f, (float)((float)width / (float)height), (float)0.1f, (float)50.0f);
        GL11.glMatrixMode((int)5888);
    }

    public void render(int delta) {
        this.render = LWJGLWindow.getTime();
        try {
            if (this.getCurrentState() != 101) {
                GL11.glLoadIdentity();
                GL11.glDisable((int)2896);
                GL11.glDepthMask((boolean)false);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glRotatef((float)this.rot, (float)0.0f, (float)0.0f, (float)1.0f);
                int index = 0;
                if (this.getCurrentState() == 1) {
                    index = this.ingame.getMap().getLocY() / 2;
                    index = Math.min(4, index);
                }
                this.backg[index].bind();
                GL11.glCallList((int)this.skyList);
                GL11.glDepthMask((boolean)true);
            }
            GL11.glLoadIdentity();
            super.render(delta);
            this.render = LWJGLWindow.getTime() - this.render;
            if (this.lastMemUpdate > 1000) {
                this.lastMemUpdate -= 1000;
                long gap = this.lastMem - Runtime.getRuntime().freeMemory();
                this.memGap = this.getNumString(gap);
                this.lastMem = Runtime.getRuntime().freeMemory();
            }
            this.lastMemUpdate += delta;
            if (this.showFPS) {
                this.window.enterOrtho();
                if (this.window.getFPS() != this.lastFPS) {
                    this.lastFPS = this.window.getFPS();
                    this.fps = this.getNumString(this.lastFPS);
                }
                SharedUI.font.drawString(5, this.window.getHeight() - 40, this.memGap, Color.black);
                SharedUI.font.drawString(5, this.window.getHeight() - 20, this.fps, Color.black);
                this.window.leaveOrtho();
            }
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
            System.exit(0);
        }
        if (this.framecap) {
            Display.sync((int)100);
        }
    }

    public void destroy() {
    }

    public void reinit() {
    }

    public static void toggleFullscreen() {
        game.toggleFullscreenImpl();
    }

    public void toggleFullscreenImpl() {
        this.fullscreen = !this.fullscreen;
        try {
            if (this.fullscreen) {
                Display.setDisplayMode((DisplayMode)new DisplayMode(originalWidth, originalHeight));
            }
            Display.setFullscreen((boolean)this.fullscreen);
            if (!this.fullscreen) {
                int size = (int)Configuration.getGlobalValue("screensize", 600.0f);
                Display.setDisplayMode((DisplayMode)new DisplayMode(size, size));
            }
        }
        catch (LWJGLException e) {
            Log.log((Throwable)e);
            this.fullscreen = false;
        }
        this.window.setWidth(Display.getDisplayMode().getWidth());
        this.window.setHeight(Display.getDisplayMode().getHeight());
        Tilt.configureDisplay(Display.getDisplayMode().getWidth(), Display.getDisplayMode().getHeight());
        this.register.createGUI();
        Configuration.setGlobalValue("fullscreen", this.fullscreen ? 1.0f : 0.0f);
    }

    public void update(int delta) {
        block14: {
            try {
                SoundStore.get().poll(delta);
                if (!this.f7down && Keyboard.isKeyDown((int)65)) {
                    boolean value = Configuration.getGlobalValue("framecap", 1.0f) == 1.0f;
                    this.framecap = !value;
                    Configuration.setGlobalValue("framecap", value ? 0.0f : 1.0f);
                }
                this.f7down = Keyboard.isKeyDown((int)65);
                if (!this.f8down && Keyboard.isKeyDown((int)66)) {
                    this.showFPS = !this.showFPS;
                }
                this.f8down = Keyboard.isKeyDown((int)66);
                if (!this.f9down && Keyboard.isKeyDown((int)67)) {
                    Tilt.toggleFullscreen();
                }
                this.f9down = Keyboard.isKeyDown((int)67);
                if (this.getCurrentState() != 1 && this.getCurrentState() != 67 && this.getCurrentState() != 32 && this.getCurrentState() != 8) {
                    this.rot += (float)delta * 0.01f;
                } else {
                    this.rot = 0.0f;
                    if (!Display.isVisible() || !Display.isActive()) {
                        return;
                    }
                }
                this.loopTime = LWJGLWindow.getTime() - this.lastHit;
                this.lastHit = LWJGLWindow.getTime();
                if (this.getCurrentState() == 1) {
                    this.steps = (delta += this.remainder) / this.timeStep;
                    this.remainder = delta % this.timeStep;
                    this.steps = Math.min(6, this.steps);
                    for (int i = 0; i < this.steps; ++i) {
                        try {
                            this.update = LWJGLWindow.getTime();
                            super.update(this.timeStep);
                            this.update = LWJGLWindow.getTime() - this.update;
                            continue;
                        }
                        catch (Throwable e) {
                            Log.log((Throwable)e);
                            System.exit(0);
                        }
                    }
                    break block14;
                }
                try {
                    super.update(delta);
                }
                catch (Throwable e) {
                    Log.log((Throwable)e);
                    System.exit(0);
                }
            }
            catch (Throwable e) {
                Log.log((Throwable)e);
                System.exit(0);
            }
        }
    }

    private void buildSkyBox() throws IOException {
        float size = 7.5f;
        this.skyList = GL11.glGenLists((int)1);
        GL11.glNewList((int)this.skyList, (int)4864);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)(1.0f * size), (float)(-1.0f * size), (float)-10.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)(1.0f * size), (float)(1.0f * size), (float)-10.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)(-1.0f * size), (float)(1.0f * size), (float)-10.0f);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)(-1.0f * size), (float)(-1.0f * size), (float)-10.0f);
        GL11.glEnd();
        GL11.glEndList();
    }

    public static void exit() {
        if (!Tilt.doClose()) {
            Display.destroy();
            System.exit(0);
        }
    }

    public static boolean doClose() {
        if (!Tilt.checkNag()) {
            return false;
        }
        if (game.getCurrentState() == 32) {
            return false;
        }
        game.changeToState(32, (Transition)new FadeOutTransition(Color.white), (Transition)new FadeInTransition(Color.white));
        return true;
    }

    public static void initGL() {
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2884);
        GL11.glShadeModel((int)7425);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClearDepth((double)1.0);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
    }

    public static boolean tryAntialias(LWJGLWindow window) {
        int size = (int)Configuration.getGlobalValue("screensize", 600.0f);
        Configuration.setGlobalValue("antialias", 0.0f);
        try {
            Display.destroy();
            Display.setDisplayMode((DisplayMode)new DisplayMode(size, size));
            Display.create((PixelFormat)new PixelFormat(0, 16, 0, 2));
            Tilt.initGL();
            Tilt.configureDisplay(size, size);
            try {
                window.setIcon("res/icon.tga");
            }
            catch (IOException e) {
                Log.log((Throwable)e);
            }
            Configuration.setGlobalValue("antialias", 1.0f);
            return true;
        }
        catch (LWJGLException e) {
            Log.log((Throwable)e);
            try {
                Display.create();
                Tilt.initGL();
                Tilt.configureDisplay(size, size);
            }
            catch (Exception x) {
                Log.log((Throwable)e);
            }
            try {
                window.setIcon("res/icon.tga");
            }
            catch (IOException x) {
                Log.log((Throwable)x);
            }
            return false;
        }
    }

    public static void main(String[] argv) {
        File file = new File(System.getProperty("user.home"));
        file = new File(file, ".tiltilation");
        file.mkdirs();
        file = new File(file, "tiltilation.log");
        try {
            Log.setOutputStream((PrintStream)new PrintStream(new FileOutputStream(file)));
        }
        catch (Exception e) {
            System.out.println("Error creating log file");
            Log.log((Throwable)e);
        }
        new Tilt().startRendering();
    }

    public void loadingFailed(Loadable element, IOException e) {
        Sys.alert((String)"Failure", (String)"Resources not found, please reinstall Tiltilation");
        Display.destroy();
        System.exit(0);
    }

    public void loadingCompleted() {
        this.changeToState(10, (Transition)new FadeOutTransition(Color.white), (Transition)new FadeInTransition(Color.white));
    }

    public static boolean checkNag() {
        if (TiltController.ALL) {
            return false;
        }
        int gameCount = (int)Configuration.getGlobalValue("gamecount", 0.0f);
        Configuration.setGlobalValue("gamecount", ++gameCount);
        return gameCount > 2;
    }

    public boolean closeRequested() {
        return Tilt.doClose();
    }

    private class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        public void write(int b) throws IOException {
        }
    }
}

